/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.KeyEncapsulation;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.kems.ECIESKEMExtractor;
import com.enterprisedt.bouncycastle.crypto.kems.ECIESKEMGenerator;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private DerivationFunction a;
    private SecureRandom b;
    private ECKeyParameters c;
    private boolean d;
    private boolean e;
    private boolean f;

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.a = kdf;
        this.b = rnd;
        this.d = false;
        this.e = false;
        this.f = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.a = kdf;
        this.b = rnd;
        this.d = cofactorMode;
        this.e = cofactorMode ? false : oldCofactorMode;
        this.f = singleHashMode;
    }

    @Override
    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.c = (ECKeyParameters)key;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ECIESKem", ConstraintUtils.bitsOfSecurityFor(this.c.getParameters().getCurve()), key, CryptoServicePurpose.ANY));
    }

    @Override
    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (!(this.c instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        ECIESKEMGenerator eCIESKEMGenerator = new ECIESKEMGenerator(keyLen, this.a, this.b, this.d, this.e, this.f);
        SecretWithEncapsulation secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(this.c);
        byte[] byArray = secretWithEncapsulation.getEncapsulation();
        System.arraycopy(byArray, 0, out, outOff, byArray.length);
        return new KeyParameter(secretWithEncapsulation.getSecret());
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    @Override
    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        if (!(this.c instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.c;
        ECIESKEMExtractor eCIESKEMExtractor = new ECIESKEMExtractor(eCPrivateKeyParameters, keyLen, this.a, this.d, this.e, this.f);
        byte[] byArray = eCIESKEMExtractor.extractSecret(Arrays.copyOfRange(in, inOff, inOff + inLen));
        return new KeyParameter(byArray);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }
}

