/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.kems.RSAKEMGenerator;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

public class RSAKEMExtractor
implements EncapsulatedSecretExtractor {
    private final RSAKeyParameters a;
    private final int b;
    private DerivationFunction c;

    public RSAKEMExtractor(RSAKeyParameters privKey, int keyLen, DerivationFunction kdf) {
        if (!privKey.isPrivate()) {
            throw new IllegalArgumentException("private key required for encryption");
        }
        this.a = privKey;
        this.b = keyLen;
        this.c = kdf;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKem", ConstraintUtils.bitsOfSecurityFor(this.a.getModulus()), privKey, CryptoServicePurpose.DECRYPTION));
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        BigInteger bigInteger = this.a.getModulus();
        BigInteger bigInteger2 = this.a.getExponent();
        BigInteger bigInteger3 = new BigInteger(1, encapsulation);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return RSAKEMGenerator.a(this.c, bigInteger, bigInteger4, this.b);
    }

    @Override
    public int getEncapsulationLength() {
        return (this.a.getModulus().bitLength() + 7) / 8;
    }
}

