/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.macs.a;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CFBBlockCipherMac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private a d;
    private BlockCipherPadding e = null;
    private int f;

    public CFBBlockCipherMac(BlockCipher cipher) {
        this(cipher, 8, cipher.getBlockSize() * 8 / 2, null);
    }

    public CFBBlockCipherMac(BlockCipher cipher, BlockCipherPadding padding) {
        this(cipher, 8, cipher.getBlockSize() * 8 / 2, padding);
    }

    public CFBBlockCipherMac(BlockCipher cipher, int cfbBitSize, int macSizeInBits) {
        this(cipher, cfbBitSize, macSizeInBits, null);
    }

    public CFBBlockCipherMac(BlockCipher cipher, int cfbBitSize, int macSizeInBits, BlockCipherPadding padding) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.a = new byte[cipher.getBlockSize()];
        this.d = new a(cipher, cfbBitSize);
        this.e = padding;
        this.f = macSizeInBits / 8;
        this.b = new byte[this.d.b()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.d.a();
    }

    @Override
    public void init(CipherParameters params) {
        this.reset();
        this.d.a(params);
    }

    @Override
    public int getMacSize() {
        return this.f;
    }

    @Override
    public void update(byte in) {
        if (this.c == this.b.length) {
            this.d.a(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.d.b();
        int n3 = 0;
        int n4 = n2 - this.c;
        if (len > n4) {
            System.arraycopy(in, inOff, this.b, this.c, n4);
            n3 += this.d.a(this.b, 0, this.a, 0);
            this.c = 0;
            len -= n4;
            inOff += n4;
            while (len > n2) {
                n3 += this.d.a(in, inOff, this.a, 0);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.b, this.c, len);
        this.c += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int n2 = this.d.b();
        if (this.e == null) {
            while (this.c < n2) {
                this.b[this.c] = 0;
                ++this.c;
            }
        } else {
            this.e.addPadding(this.b, this.c);
        }
        this.d.a(this.b, 0, this.a, 0);
        this.d.a(this.a);
        System.arraycopy(this.a, 0, out, outOff, this.f);
        this.reset();
        return this.f;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.c();
    }
}

