/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.macs.CMac;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CTRModeCipher;
import com.enterprisedt.bouncycastle.crypto.modes.SICBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;

public class EAXBlockCipher
implements AEADBlockCipher {
    private CTRModeCipher a;
    private boolean b;
    private int c;
    private Mac d;
    private byte[] e;
    private byte[] f;
    private byte[] g;
    private int h;
    private byte[] i;
    private int j;
    private boolean k;
    private byte[] l;

    public EAXBlockCipher(BlockCipher cipher) {
        this.c = cipher.getBlockSize();
        this.d = new CMac(cipher);
        this.g = new byte[this.c];
        this.f = new byte[this.d.getMacSize()];
        this.e = new byte[this.d.getMacSize()];
        this.a = SICBlockCipher.newInstance(cipher);
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getUnderlyingCipher().getAlgorithmName() + "/EAX";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.a.getUnderlyingCipher();
    }

    public int getBlockSize() {
        return this.a.getBlockSize();
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters cipherParameters;
        byte[] byArray;
        Object object;
        this.b = forEncryption;
        if (params instanceof AEADParameters) {
            object = (AEADParameters)params;
            byArray = ((AEADParameters)object).getNonce();
            this.l = ((AEADParameters)object).getAssociatedText();
            this.h = ((AEADParameters)object).getMacSize() / 8;
            cipherParameters = ((AEADParameters)object).getKey();
        } else if (params instanceof ParametersWithIV) {
            object = (ParametersWithIV)params;
            byArray = ((ParametersWithIV)object).getIV();
            this.l = null;
            this.h = this.d.getMacSize() / 2;
            cipherParameters = ((ParametersWithIV)object).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to EAX");
        }
        this.i = new byte[forEncryption ? this.c : this.c + this.h];
        object = new byte[this.c];
        this.d.init(cipherParameters);
        object[this.c - 1] = false;
        this.d.update((byte[])object, 0, this.c);
        this.d.update(byArray, 0, byArray.length);
        this.d.doFinal(this.e, 0);
        this.a.init(true, new ParametersWithIV(cipherParameters, this.e));
        this.reset();
    }

    private void a() {
        if (this.k) {
            return;
        }
        this.k = true;
        this.d.doFinal(this.f, 0);
        byte[] byArray = new byte[this.c];
        byArray[this.c - 1] = 2;
        this.d.update(byArray, 0, this.c);
    }

    private void b() {
        byte[] byArray = new byte[this.c];
        this.d.doFinal(byArray, 0);
        for (int i2 = 0; i2 < this.g.length; ++i2) {
            this.g[i2] = (byte)(this.e[i2] ^ this.f[i2] ^ byArray[i2]);
        }
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl) {
        this.a.reset();
        this.d.reset();
        this.j = 0;
        Arrays.fill(this.i, (byte)0);
        if (bl) {
            Arrays.fill(this.g, (byte)0);
        }
        byte[] byArray = new byte[this.c];
        byArray[this.c - 1] = 1;
        this.d.update(byArray, 0, this.c);
        this.k = false;
        if (this.l != null) {
            this.processAADBytes(this.l, 0, this.l.length);
        }
    }

    @Override
    public void processAADByte(byte in) {
        if (this.k) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.d.update(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        if (this.k) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.d.update(in, inOff, len);
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        this.a();
        return this.a(in, out, outOff);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        this.a();
        if (in.length < inOff + len) {
            throw new DataLengthException("Input buffer too short");
        }
        int n2 = 0;
        for (int i2 = 0; i2 != len; ++i2) {
            n2 += this.a(in[inOff + i2], out, outOff + n2);
        }
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        this.a();
        int n2 = this.j;
        byte[] byArray = new byte[this.i.length];
        this.j = 0;
        if (this.b) {
            if (out.length < outOff + n2 + this.h) {
                throw new OutputLengthException("Output buffer too short");
            }
            this.a.processBlock(this.i, 0, byArray, 0);
            System.arraycopy(byArray, 0, out, outOff, n2);
            this.d.update(byArray, 0, n2);
            this.b();
            System.arraycopy(this.g, 0, out, outOff + n2, this.h);
            this.a(false);
            return n2 + this.h;
        }
        if (n2 < this.h) {
            throw new InvalidCipherTextException("data too short");
        }
        if (out.length < outOff + n2 - this.h) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (n2 > this.h) {
            this.d.update(this.i, 0, n2 - this.h);
            this.a.processBlock(this.i, 0, byArray, 0);
            System.arraycopy(byArray, 0, out, outOff, n2 - this.h);
        }
        this.b();
        if (!this.a(this.i, n2 - this.h)) {
            throw new InvalidCipherTextException("mac check in EAX failed");
        }
        this.a(false);
        return n2 - this.h;
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = new byte[this.h];
        System.arraycopy(this.g, 0, byArray, 0, this.h);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = len + this.j;
        if (!this.b) {
            if (n2 < this.h) {
                return 0;
            }
            n2 -= this.h;
        }
        return n2 - n2 % this.c;
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = len + this.j;
        if (this.b) {
            return n2 + this.h;
        }
        return n2 < this.h ? 0 : n2 - this.h;
    }

    private int a(byte by, byte[] byArray, int n2) {
        this.i[this.j++] = by;
        if (this.j == this.i.length) {
            int n3;
            if (byArray.length < n2 + this.c) {
                throw new OutputLengthException("Output buffer is too short");
            }
            if (this.b) {
                n3 = this.a.processBlock(this.i, 0, byArray, n2);
                this.d.update(byArray, n2, this.c);
            } else {
                this.d.update(this.i, 0, this.c);
                n3 = this.a.processBlock(this.i, 0, byArray, n2);
            }
            this.j = 0;
            if (!this.b) {
                System.arraycopy(this.i, this.c, this.i, 0, this.h);
                this.j = this.h;
            }
            return n3;
        }
        return 0;
    }

    private boolean a(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.h; ++i2) {
            n3 |= this.g[i2] ^ byArray[n2 + i2];
        }
        return n3 == 0;
    }
}

