/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class GCMSIVBlockCipher
implements AEADBlockCipher {
    private final BlockCipher a;
    private final GCMMultiplier b;
    private final byte[] c = new byte[16];
    private final byte[] d = new byte[16];
    private final b e;
    private final b f;
    private a g;
    private a h;
    private boolean i;
    private byte[] j;
    private byte[] k;
    private int l;
    private byte[] m = new byte[16];

    public GCMSIVBlockCipher() {
        this(AESEngine.newInstance());
    }

    public GCMSIVBlockCipher(BlockCipher pCipher) {
        this(pCipher, new Tables4kGCMMultiplier());
    }

    public GCMSIVBlockCipher(BlockCipher pCipher, GCMMultiplier pMultiplier) {
        if (pCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Cipher required with a block size of 16.");
        }
        this.a = pCipher;
        this.b = pMultiplier;
        this.e = new b();
        this.f = new b();
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.a;
    }

    @Override
    public void init(boolean pEncrypt, CipherParameters cipherParameters) throws IllegalArgumentException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        KeyParameter keyParameter = null;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            byArray = aEADParameters.getAssociatedText();
            byArray2 = aEADParameters.getNonce();
            keyParameter = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray2 = parametersWithIV.getIV();
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM-SIV");
        }
        if (byArray2 == null || byArray2.length != 12) {
            throw new IllegalArgumentException("Invalid nonce");
        }
        if (keyParameter == null || keyParameter.getKeyLength() != 16 && keyParameter.getKeyLength() != 32) {
            throw new IllegalArgumentException("Invalid key");
        }
        this.i = pEncrypt;
        this.j = byArray;
        this.k = byArray2;
        this.a(keyParameter);
        this.a();
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "-GCM-SIV";
    }

    private void a(int n2) {
        if ((this.l & 1) == 0) {
            throw new IllegalStateException("Cipher is not initialised");
        }
        if ((this.l & 2) != 0) {
            throw new IllegalStateException("AEAD data cannot be processed after ordinary data");
        }
        if (this.e.a() + Long.MIN_VALUE > (long)(0x7FFFFFE7 - n2) + Long.MIN_VALUE) {
            throw new IllegalStateException("AEAD byte count exceeded");
        }
    }

    private void b(int n2) {
        if ((this.l & 1) == 0) {
            throw new IllegalStateException("Cipher is not initialised");
        }
        if ((this.l & 2) == 0) {
            this.e.c();
            this.l |= 2;
        }
        long l2 = 0x7FFFFFE7L;
        long l3 = this.g.size();
        if (!this.i) {
            l2 += 16L;
            l3 = this.h.size();
        }
        if (l3 + Long.MIN_VALUE > l2 - (long)n2 + Long.MIN_VALUE) {
            throw new IllegalStateException("byte count exceeded");
        }
    }

    @Override
    public void processAADByte(byte pByte) {
        this.a(1);
        this.e.a(pByte);
    }

    @Override
    public void processAADBytes(byte[] pData, int pOffset, int pLen) {
        this.a(pLen);
        GCMSIVBlockCipher.a(pData, pOffset, pLen, false);
        this.e.a(pData, pOffset, pLen);
    }

    @Override
    public int processByte(byte pByte, byte[] pOutput, int pOutOffset) throws DataLengthException {
        this.b(1);
        if (this.i) {
            this.g.write(pByte);
            this.f.a(pByte);
        } else {
            this.h.write(pByte);
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] pData, int pOffset, int pLen, byte[] pOutput, int pOutOffset) throws DataLengthException {
        this.b(pLen);
        GCMSIVBlockCipher.a(pData, pOffset, pLen, false);
        if (this.i) {
            this.g.write(pData, pOffset, pLen);
            this.f.a(pData, pOffset, pLen);
        } else {
            this.h.write(pData, pOffset, pLen);
        }
        return 0;
    }

    @Override
    public int doFinal(byte[] pOutput, int pOffset) throws IllegalStateException, InvalidCipherTextException {
        this.b(0);
        GCMSIVBlockCipher.a(pOutput, pOffset, this.getOutputSize(0), true);
        if (this.i) {
            byte[] byArray = this.c();
            int n2 = 16 + this.a(byArray, pOutput, pOffset);
            System.arraycopy(byArray, 0, pOutput, pOffset + this.g.size(), 16);
            System.arraycopy(byArray, 0, this.m, 0, this.m.length);
            this.a();
            return n2;
        }
        this.b();
        int n3 = this.g.size();
        byte[] byArray = this.g.a();
        System.arraycopy(byArray, 0, pOutput, pOffset, n3);
        this.a();
        return n3;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.m);
    }

    @Override
    public int getUpdateOutputSize(int pLen) {
        return 0;
    }

    @Override
    public int getOutputSize(int pLen) {
        if (this.i) {
            return pLen + this.g.size() + 16;
        }
        int n2 = pLen + this.h.size();
        return n2 > 16 ? n2 - 16 : 0;
    }

    @Override
    public void reset() {
        this.a();
    }

    private void a() {
        if (this.g != null) {
            this.g.b();
        }
        this.e.b();
        this.f.b();
        this.g = new a();
        this.h = this.i ? null : new a();
        this.l &= 0xFFFFFFFD;
        Arrays.fill(this.c, (byte)0);
        if (this.j != null) {
            this.e.a(this.j, 0, this.j.length);
        }
    }

    private static int a(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    private static void a(byte[] byArray, int n2, int n3, boolean bl) {
        boolean bl2;
        int n4 = GCMSIVBlockCipher.a(byArray);
        int n5 = n2 + n3;
        boolean bl3 = bl2 = n3 < 0 || n2 < 0 || n5 < 0;
        if (bl2 || n5 > n4) {
            throw bl ? new OutputLengthException("Output buffer too short.") : new DataLengthException("Input buffer too short.");
        }
    }

    private int a(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3 = this.g.a();
        byte[] byArray4 = Arrays.clone(byArray);
        byArray4[15] = (byte)(byArray4[15] | 0xFFFFFF80);
        byte[] byArray5 = new byte[16];
        int n3 = this.g.size();
        int n4 = 0;
        while (n3 > 0) {
            this.a.processBlock(byArray4, 0, byArray5, 0);
            int n5 = Math.min(16, n3);
            GCMSIVBlockCipher.a(byArray5, byArray3, n4, n5);
            System.arraycopy(byArray5, 0, byArray2, n2 + n4, n5);
            n3 -= n5;
            n4 += n5;
            GCMSIVBlockCipher.c(byArray4);
        }
        return this.g.size();
    }

    private void b() throws InvalidCipherTextException {
        byte[] byArray = this.h.a();
        int n2 = this.h.size() - 16;
        if (n2 < 0) {
            throw new InvalidCipherTextException("Data too short");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, n2, n2 + 16);
        byte[] byArray3 = Arrays.clone(byArray2);
        byArray3[15] = (byte)(byArray3[15] | 0xFFFFFF80);
        byte[] byArray4 = new byte[16];
        int n3 = 0;
        while (n2 > 0) {
            this.a.processBlock(byArray3, 0, byArray4, 0);
            int n4 = Math.min(16, n2);
            GCMSIVBlockCipher.a(byArray4, byArray, n3, n4);
            this.g.write(byArray4, 0, n4);
            this.f.a(byArray4, 0, n4);
            n2 -= n4;
            n3 += n4;
            GCMSIVBlockCipher.c(byArray3);
        }
        byte[] byArray5 = this.c();
        if (!Arrays.constantTimeAreEqual(byArray5, byArray2)) {
            this.reset();
            throw new InvalidCipherTextException("mac check failed");
        }
        System.arraycopy(byArray5, 0, this.m, 0, this.m.length);
    }

    private byte[] c() {
        this.f.c();
        byte[] byArray = this.d();
        byte[] byArray2 = new byte[16];
        for (int i2 = 0; i2 < 12; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ this.k[i2]);
        }
        byArray[15] = (byte)(byArray[15] & 0xFFFFFF7F);
        this.a.processBlock(byArray, 0, byArray2, 0);
        return byArray2;
    }

    private byte[] d() {
        byte[] byArray = new byte[16];
        this.e();
        GCMSIVBlockCipher.b(this.c, 0, 16, byArray);
        return byArray;
    }

    private void e() {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(8L * this.f.a(), byArray, 0);
        Pack.longToBigEndian(8L * this.e.a(), byArray, 8);
        this.b(byArray);
    }

    private void b(byte[] byArray) {
        GCMSIVBlockCipher.a(this.c, byArray);
        this.b.multiplyH(this.c);
    }

    private static void b(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = 0;
        int n5 = 15;
        while (n4 < n3) {
            byArray2[n5] = byArray[n2 + n4];
            ++n4;
            --n5;
        }
    }

    private static void a(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }

    private static void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[i2 + n2]);
        }
    }

    private static void c(byte[] byArray) {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] != 0) break;
        }
    }

    private static void d(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = (byte)(by >> 1 & 0x7F | n2);
            n2 = (by & 1) == 0 ? 0 : -128;
        }
        if (n2 != 0) {
            byArray[0] = (byte)(byArray[0] ^ 0xFFFFFFE1);
        }
    }

    private void a(KeyParameter keyParameter) {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[keyParameter.getKeyLength()];
        System.arraycopy(this.k, 0, byArray, 4, 12);
        this.a.init(true, keyParameter);
        int n2 = 0;
        this.a.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray3, n2, 8);
        byArray[0] = (byte)(byArray[0] + 1);
        this.a.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray3, n2 += 8, 8);
        byArray[0] = (byte)(byArray[0] + 1);
        n2 = 0;
        this.a.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray4, n2, 8);
        byArray[0] = (byte)(byArray[0] + 1);
        this.a.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray4, n2 += 8, 8);
        if (byArray4.length == 32) {
            byArray[0] = (byte)(byArray[0] + 1);
            this.a.processBlock(byArray, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray4, n2 += 8, 8);
            byArray[0] = (byte)(byArray[0] + 1);
            this.a.processBlock(byArray, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray4, n2 += 8, 8);
        }
        this.a.init(true, new KeyParameter(byArray4));
        GCMSIVBlockCipher.b(byArray3, 0, 16, byArray2);
        GCMSIVBlockCipher.d(byArray2);
        this.b.init(byArray2);
        this.l |= 1;
    }

    private class b {
        private final byte[] b = new byte[16];
        private final byte[] c = new byte[1];
        private int d;
        private long e;

        private b() {
        }

        long a() {
            return this.e;
        }

        void b() {
            this.d = 0;
            this.e = 0L;
        }

        void a(byte by) {
            this.c[0] = by;
            this.a(this.c, 0, 1);
        }

        void a(byte[] byArray, int n2, int n3) {
            int n4 = 16 - this.d;
            int n5 = 0;
            int n6 = n3;
            if (this.d > 0 && n3 >= n4) {
                System.arraycopy(byArray, n2, this.b, this.d, n4);
                GCMSIVBlockCipher.b(this.b, 0, 16, GCMSIVBlockCipher.this.d);
                GCMSIVBlockCipher.this.b(GCMSIVBlockCipher.this.d);
                n5 += n4;
                n6 -= n4;
                this.d = 0;
            }
            while (n6 >= 16) {
                GCMSIVBlockCipher.b(byArray, n2 + n5, 16, GCMSIVBlockCipher.this.d);
                GCMSIVBlockCipher.this.b(GCMSIVBlockCipher.this.d);
                n5 += 16;
                n6 -= 16;
            }
            if (n6 > 0) {
                System.arraycopy(byArray, n2 + n5, this.b, this.d, n6);
                this.d += n6;
            }
            this.e += (long)n3;
        }

        void c() {
            if (this.d > 0) {
                Arrays.fill(GCMSIVBlockCipher.this.d, (byte)0);
                GCMSIVBlockCipher.b(this.b, 0, this.d, GCMSIVBlockCipher.this.d);
                GCMSIVBlockCipher.this.b(GCMSIVBlockCipher.this.d);
            }
        }
    }

    private static class a
    extends ByteArrayOutputStream {
        a() {
        }

        byte[] a() {
            return this.buf;
        }

        void b() {
            Arrays.fill(this.a(), (byte)0);
        }
    }
}

