/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMUtil;
import java.util.ArrayList;
import java.util.List;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private List a;

    @Override
    public void init(byte[] x) {
        long[] lArray = GCMUtil.asLongs(x);
        if (this.a != null && 0L != GCMUtil.areEqual(lArray, (long[])this.a.get(0))) {
            return;
        }
        this.a = new ArrayList(8);
        this.a.add(lArray);
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        long[] lArray = GCMUtil.oneAsLongs();
        int n2 = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                GCMUtil.multiply(lArray, this.a(n2));
            }
            ++n2;
            pow >>>= 1;
        }
        GCMUtil.asBytes(lArray, output);
    }

    private long[] a(int n2) {
        int n3 = this.a.size() - 1;
        if (n3 < n2) {
            long[] lArray = (long[])this.a.get(n3);
            do {
                long[] lArray2 = new long[2];
                GCMUtil.square(lArray, lArray2);
                this.a.add(lArray2);
                lArray = lArray2;
            } while (++n3 < n2);
        }
        return (long[])this.a.get(n2);
    }
}

