/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.enterprisedt.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] a;
    private long[][][] b;

    @Override
    public void init(byte[] H) {
        if (this.b == null) {
            this.b = new long[16][256][2];
        } else if (0 != GCMUtil.areEqual(this.a, H)) {
            return;
        }
        this.a = new byte[16];
        GCMUtil.copy(H, this.a);
        for (int i2 = 0; i2 < 16; ++i2) {
            long[][] lArray = this.b[i2];
            if (i2 == 0) {
                GCMUtil.asLongs(this.a, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.b[i2 - 1][1], lArray[1]);
            }
            for (int i3 = 2; i3 < 256; i3 += 2) {
                GCMUtil.divideP(lArray[i3 >> 1], lArray[i3]);
                GCMUtil.xor(lArray[i3], lArray[1], lArray[i3 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        long[] lArray = this.b[0][x[0] & 0xFF];
        long[] lArray2 = this.b[1][x[1] & 0xFF];
        long[] lArray3 = this.b[2][x[2] & 0xFF];
        long[] lArray4 = this.b[3][x[3] & 0xFF];
        long[] lArray5 = this.b[4][x[4] & 0xFF];
        long[] lArray6 = this.b[5][x[5] & 0xFF];
        long[] lArray7 = this.b[6][x[6] & 0xFF];
        long[] lArray8 = this.b[7][x[7] & 0xFF];
        long[] lArray9 = this.b[8][x[8] & 0xFF];
        long[] lArray10 = this.b[9][x[9] & 0xFF];
        long[] lArray11 = this.b[10][x[10] & 0xFF];
        long[] lArray12 = this.b[11][x[11] & 0xFF];
        long[] lArray13 = this.b[12][x[12] & 0xFF];
        long[] lArray14 = this.b[13][x[13] & 0xFF];
        long[] lArray15 = this.b[14][x[14] & 0xFF];
        long[] lArray16 = this.b[15][x[15] & 0xFF];
        long l2 = lArray[0] ^ lArray2[0] ^ lArray3[0] ^ lArray4[0] ^ lArray5[0] ^ lArray6[0] ^ lArray7[0] ^ lArray8[0] ^ lArray9[0] ^ lArray10[0] ^ lArray11[0] ^ lArray12[0] ^ lArray13[0] ^ lArray14[0] ^ lArray15[0] ^ lArray16[0];
        long l3 = lArray[1] ^ lArray2[1] ^ lArray3[1] ^ lArray4[1] ^ lArray5[1] ^ lArray6[1] ^ lArray7[1] ^ lArray8[1] ^ lArray9[1] ^ lArray10[1] ^ lArray11[1] ^ lArray12[1] ^ lArray13[1] ^ lArray14[1] ^ lArray15[1] ^ lArray16[1];
        Pack.longToBigEndian(l2, x, 0);
        Pack.longToBigEndian(l3, x, 8);
    }
}

