/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.enterprisedt.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] a;
    private long[][][] b;

    @Override
    public void init(byte[] H) {
        if (this.b == null) {
            this.b = new long[2][256][2];
        } else if (0 != GCMUtil.areEqual(this.a, H)) {
            return;
        }
        this.a = new byte[16];
        GCMUtil.copy(H, this.a);
        for (int i2 = 0; i2 < 2; ++i2) {
            long[][] lArray = this.b[i2];
            if (i2 == 0) {
                GCMUtil.asLongs(this.a, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.b[i2 - 1][1], lArray[1]);
            }
            for (int i3 = 2; i3 < 256; i3 += 2) {
                GCMUtil.divideP(lArray[i3 >> 1], lArray[i3]);
                GCMUtil.xor(lArray[i3], lArray[1], lArray[i3 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        long[][] lArray = this.b[0];
        long[][] lArray2 = this.b[1];
        long[] lArray3 = lArray[x[14] & 0xFF];
        long[] lArray4 = lArray2[x[15] & 0xFF];
        long l2 = lArray3[0] ^ lArray4[0];
        long l3 = lArray3[1] ^ lArray4[1];
        for (int i2 = 12; i2 >= 0; i2 -= 2) {
            lArray3 = lArray[x[i2] & 0xFF];
            lArray4 = lArray2[x[i2 + 1] & 0xFF];
            long l4 = l3 << 48;
            l3 = lArray3[1] ^ lArray4[1] ^ (l3 >>> 16 | l2 << 48);
            l2 = lArray3[0] ^ lArray4[0] ^ l2 >>> 16 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        }
        Pack.longToBigEndian(l2, x, 0);
        Pack.longToBigEndian(l3, x, 8);
    }
}

