/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.kgcm;

import com.enterprisedt.bouncycastle.math.raw.Interleave;

public class KGCMUtil_512 {
    public static final int SIZE = 8;

    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
        z[3] = x[3] ^ y[3];
        z[4] = x[4] ^ y[4];
        z[5] = x[5] ^ y[5];
        z[6] = x[6] ^ y[6];
        z[7] = x[7] ^ y[7];
    }

    public static void copy(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
        z[5] = x[5];
        z[6] = x[6];
        z[7] = x[7];
    }

    public static boolean equal(long[] x, long[] y) {
        long l2 = 0L;
        l2 |= x[0] ^ y[0];
        l2 |= x[1] ^ y[1];
        l2 |= x[2] ^ y[2];
        l2 |= x[3] ^ y[3];
        l2 |= x[4] ^ y[4];
        l2 |= x[5] ^ y[5];
        l2 |= x[6] ^ y[6];
        return (l2 |= x[7] ^ y[7]) == 0L;
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long l2 = y[0];
        long l3 = y[1];
        long l4 = y[2];
        long l5 = y[3];
        long l6 = y[4];
        long l7 = y[5];
        long l8 = y[6];
        long l9 = y[7];
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        long l13 = 0L;
        long l14 = 0L;
        long l15 = 0L;
        long l16 = 0L;
        long l17 = 0L;
        long l18 = 0L;
        for (int i2 = 0; i2 < 8; i2 += 2) {
            long l19 = x[i2];
            long l20 = x[i2 + 1];
            for (int i3 = 0; i3 < 64; ++i3) {
                long l21 = -(l19 & 1L);
                l19 >>>= 1;
                l10 ^= l2 & l21;
                l11 ^= l3 & l21;
                l12 ^= l4 & l21;
                l13 ^= l5 & l21;
                l14 ^= l6 & l21;
                l15 ^= l7 & l21;
                l16 ^= l8 & l21;
                l17 ^= l9 & l21;
                long l22 = -(l20 & 1L);
                l20 >>>= 1;
                l11 ^= l2 & l22;
                l12 ^= l3 & l22;
                l13 ^= l4 & l22;
                l14 ^= l5 & l22;
                l15 ^= l6 & l22;
                l16 ^= l7 & l22;
                l17 ^= l8 & l22;
                l18 ^= l9 & l22;
                long l23 = l9 >> 63;
                l9 = l9 << 1 | l8 >>> 63;
                l8 = l8 << 1 | l7 >>> 63;
                l7 = l7 << 1 | l6 >>> 63;
                l6 = l6 << 1 | l5 >>> 63;
                l5 = l5 << 1 | l4 >>> 63;
                l4 = l4 << 1 | l3 >>> 63;
                l3 = l3 << 1 | l2 >>> 63;
                l2 = l2 << 1 ^ l23 & 0x125L;
            }
            long l24 = l9;
            l9 = l8;
            l8 = l7;
            l7 = l6;
            l6 = l5;
            l5 = l4;
            l4 = l3;
            l3 = l2 ^ l24 >>> 62 ^ l24 >>> 59 ^ l24 >>> 56;
            l2 = l24 ^ l24 << 2 ^ l24 << 5 ^ l24 << 8;
        }
        z[0] = l10 ^= l18 ^ l18 << 2 ^ l18 << 5 ^ l18 << 8;
        z[1] = l11 ^= l18 >>> 62 ^ l18 >>> 59 ^ l18 >>> 56;
        z[2] = l12;
        z[3] = l13;
        z[4] = l14;
        z[5] = l15;
        z[6] = l16;
        z[7] = l17;
    }

    public static void multiplyX(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = x[2];
        long l5 = x[3];
        long l6 = x[4];
        long l7 = x[5];
        long l8 = x[6];
        long l9 = x[7];
        long l10 = l9 >> 63;
        z[0] = l2 << 1 ^ l10 & 0x125L;
        z[1] = l3 << 1 | l2 >>> 63;
        z[2] = l4 << 1 | l3 >>> 63;
        z[3] = l5 << 1 | l4 >>> 63;
        z[4] = l6 << 1 | l5 >>> 63;
        z[5] = l7 << 1 | l6 >>> 63;
        z[6] = l8 << 1 | l7 >>> 63;
        z[7] = l9 << 1 | l8 >>> 63;
    }

    public static void multiplyX8(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = x[2];
        long l5 = x[3];
        long l6 = x[4];
        long l7 = x[5];
        long l8 = x[6];
        long l9 = x[7];
        long l10 = l9 >>> 56;
        z[0] = l2 << 8 ^ l10 ^ l10 << 2 ^ l10 << 5 ^ l10 << 8;
        z[1] = l3 << 8 | l2 >>> 56;
        z[2] = l4 << 8 | l3 >>> 56;
        z[3] = l5 << 8 | l4 >>> 56;
        z[4] = l6 << 8 | l5 >>> 56;
        z[5] = l7 << 8 | l6 >>> 56;
        z[6] = l8 << 8 | l7 >>> 56;
        z[7] = l9 << 8 | l8 >>> 56;
    }

    public static void one(long[] z) {
        z[0] = 1L;
        z[1] = 0L;
        z[2] = 0L;
        z[3] = 0L;
        z[4] = 0L;
        z[5] = 0L;
        z[6] = 0L;
        z[7] = 0L;
    }

    public static void square(long[] x, long[] z) {
        int n2;
        long[] lArray = new long[16];
        for (n2 = 0; n2 < 8; ++n2) {
            Interleave.expand64To128(x[n2], lArray, n2 << 1);
        }
        n2 = 16;
        while (--n2 >= 8) {
            long l2 = lArray[n2];
            int n3 = n2 - 8;
            lArray[n3] = lArray[n3] ^ (l2 ^ l2 << 2 ^ l2 << 5 ^ l2 << 8);
            int n4 = n2 - 8 + 1;
            lArray[n4] = lArray[n4] ^ (l2 >>> 62 ^ l2 >>> 59 ^ l2 >>> 56);
        }
        KGCMUtil_512.copy(lArray, z);
    }

    public static void x(long[] z) {
        z[0] = 2L;
        z[1] = 0L;
        z[2] = 0L;
        z[3] = 0L;
        z[4] = 0L;
        z[5] = 0L;
        z[6] = 0L;
        z[7] = 0L;
    }

    public static void zero(long[] z) {
        z[0] = 0L;
        z[1] = 0L;
        z[2] = 0L;
        z[3] = 0L;
        z[4] = 0L;
        z[5] = 0L;
        z[6] = 0L;
        z[7] = 0L;
    }
}

