/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO7816d4Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "ISO7816-4";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int n2 = in.length - inOff;
        in[inOff] = -128;
        ++inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return n2;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2 = -1;
        int n3 = -1;
        int n4 = in.length;
        while (--n4 >= 0) {
            int n5 = in[n4] & 0xFF;
            int n6 = (n5 ^ 0) - 1 >> 31;
            int n7 = (n5 ^ 0x80) - 1 >> 31;
            n2 ^= (n4 ^ n2) & (n3 & n7);
            n3 &= n6;
        }
        if (n2 < 0) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return in.length - n2;
    }
}

