/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.util.Arrays;

public class DSAValidationParameters {
    private int a;
    private byte[] b;
    private int c;

    public DSAValidationParameters(byte[] seed, int counter) {
        this(seed, counter, -1);
    }

    public DSAValidationParameters(byte[] seed, int counter, int usageIndex) {
        this.b = Arrays.clone(seed);
        this.c = counter;
        this.a = usageIndex;
    }

    public int getCounter() {
        return this.c;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.b);
    }

    public int getUsageIndex() {
        return this.a;
    }

    public int hashCode() {
        return this.c ^ Arrays.hashCode(this.b);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof DSAValidationParameters)) {
            return false;
        }
        DSAValidationParameters dSAValidationParameters = (DSAValidationParameters)o2;
        if (dSAValidationParameters.c != this.c) {
            return false;
        }
        return Arrays.areEqual(this.b, dSAValidationParameters.b);
    }
}

