/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class Ed448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private final byte[] b = new byte[57];
    private Ed448PublicKeyParameters c;

    public Ed448PrivateKeyParameters(SecureRandom random) {
        super(true);
        Ed448.generatePrivateKey(random, this.b);
    }

    public Ed448PrivateKeyParameters(byte[] buf) {
        this(Ed448PrivateKeyParameters.a(buf), 0);
    }

    public Ed448PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.b, 0, 57);
    }

    public Ed448PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (57 != Streams.readFully(input, this.b)) {
            throw new EOFException("EOF encountered in middle of Ed448 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.b, 0, buf, off, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ed448PublicKeyParameters generatePublicKey() {
        byte[] byArray = this.b;
        synchronized (this.b) {
            if (null == this.c) {
                this.c = new Ed448PublicKeyParameters(Ed448.generatePublicKey(this.b, 0));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.c;
        }
    }

    public void sign(int algorithm, Ed448PublicKeyParameters publicKey, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        this.sign(algorithm, ctx, msg, msgOff, msgLen, sig, sigOff);
    }

    public void sign(int algorithm, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        Ed448PublicKeyParameters ed448PublicKeyParameters = this.generatePublicKey();
        byte[] byArray = new byte[57];
        ed448PublicKeyParameters.encode(byArray, 0);
        switch (algorithm) {
            case 0: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                Ed448.sign(this.b, 0, byArray, 0, ctx, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 1: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                Ed448.signPrehash(this.b, 0, byArray, 0, ctx, msg, msgOff, sig, sigOff);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 57) {
            throw new IllegalArgumentException("'buf' must have length 57");
        }
        return byArray;
    }
}

