/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public final class KDFFeedbackParameters
implements DerivationParameters {
    private final byte[] a;
    private final byte[] b;
    private final boolean c;
    private final int d;
    private final byte[] e;

    private KDFFeedbackParameters(byte[] ki, byte[] iv, byte[] fixedInputData, int r2, boolean useCounter) {
        if (ki == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.a = Arrays.clone(ki);
        this.e = fixedInputData == null ? new byte[0] : Arrays.clone(fixedInputData);
        this.d = r2;
        this.b = iv == null ? new byte[0] : Arrays.clone(iv);
        this.c = useCounter;
    }

    public static KDFFeedbackParameters createWithCounter(byte[] ki, byte[] iv, byte[] fixedInputData, int r2) {
        if (r2 != 8 && r2 != 16 && r2 != 24 && r2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        return new KDFFeedbackParameters(ki, iv, fixedInputData, r2, true);
    }

    public static KDFFeedbackParameters createWithoutCounter(byte[] ki, byte[] iv, byte[] fixedInputData) {
        return new KDFFeedbackParameters(ki, iv, fixedInputData, -1, false);
    }

    public byte[] getKI() {
        return this.a;
    }

    public byte[] getIV() {
        return this.b;
    }

    public boolean useCounter() {
        return this.c;
    }

    public int getR() {
        return this.d;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.e);
    }
}

