/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X25519;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class X25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SECRET_SIZE = 32;
    private final byte[] b = new byte[32];

    public X25519PrivateKeyParameters(SecureRandom random) {
        super(true);
        X25519.generatePrivateKey(random, this.b);
    }

    public X25519PrivateKeyParameters(byte[] buf) {
        this(X25519PrivateKeyParameters.a(buf), 0);
    }

    public X25519PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.b, 0, 32);
    }

    public X25519PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (32 != Streams.readFully(input, this.b)) {
            throw new EOFException("EOF encountered in middle of X25519 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.b, 0, buf, off, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.b);
    }

    public X25519PublicKeyParameters generatePublicKey() {
        byte[] byArray = new byte[32];
        X25519.generatePublicKey(this.b, 0, byArray, 0);
        return new X25519PublicKeyParameters(byArray, 0);
    }

    public void generateSecret(X25519PublicKeyParameters publicKey, byte[] buf, int off) {
        byte[] byArray = new byte[32];
        publicKey.encode(byArray, 0);
        if (!X25519.calculateAgreement(this.b, 0, byArray, 0, buf, off)) {
            throw new IllegalStateException("X25519 agreement failed");
        }
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("'buf' must have length 32");
        }
        return byArray;
    }
}

