/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.engines.DESedeEngine;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySourceProvider;
import com.enterprisedt.bouncycastle.crypto.prng.SP800SecureRandom;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.CTRSP800DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.HMacSP800DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.HashSP800DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class SP800SecureRandomBuilder {
    private final SecureRandom a;
    private final EntropySourceProvider b;
    private byte[] c;
    private int d = 256;
    private int e = 256;

    public SP800SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public SP800SecureRandomBuilder(SecureRandom entropySource, boolean predictionResistant) {
        this.a = entropySource;
        this.b = new BasicEntropySourceProvider(this.a, predictionResistant);
    }

    public SP800SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.a = null;
        this.b = entropySourceProvider;
    }

    public SP800SecureRandomBuilder setPersonalizationString(byte[] personalizationString) {
        this.c = Arrays.clone(personalizationString);
        return this;
    }

    public SP800SecureRandomBuilder setSecurityStrength(int securityStrength) {
        this.d = securityStrength;
        return this;
    }

    public SP800SecureRandomBuilder setEntropyBitsRequired(int entropyBitsRequired) {
        this.e = entropyBitsRequired;
        return this;
    }

    public SP800SecureRandom buildHash(Digest digest, byte[] nonce, boolean predictionResistant) {
        return new SP800SecureRandom(this.a, this.b.get(this.e), new c(digest, nonce, this.c, this.d), predictionResistant);
    }

    public SP800SecureRandom buildCTR(BlockCipher cipher, int keySizeInBits, byte[] nonce, boolean predictionResistant) {
        return new SP800SecureRandom(this.a, this.b.get(this.e), new a(cipher, keySizeInBits, nonce, this.c, this.d), predictionResistant);
    }

    public SP800SecureRandom buildHMAC(Mac hMac, byte[] nonce, boolean predictionResistant) {
        return new SP800SecureRandom(this.a, this.b.get(this.e), new b(hMac, nonce, this.c, this.d), predictionResistant);
    }

    private static String b(Digest digest) {
        String string = digest.getAlgorithmName();
        int n2 = string.indexOf(45);
        if (n2 > 0 && !string.startsWith("SHA3")) {
            return string.substring(0, n2) + string.substring(n2 + 1);
        }
        return string;
    }

    private static class a
    implements com.enterprisedt.bouncycastle.crypto.prng.a {
        private final BlockCipher a;
        private final int b;
        private final byte[] c;
        private final byte[] d;
        private final int e;

        public a(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3) {
            this.a = blockCipher;
            this.b = n2;
            this.c = byArray;
            this.d = byArray2;
            this.e = n3;
        }

        @Override
        public String a() {
            if (this.a instanceof DESedeEngine) {
                return "CTR-DRBG-3KEY-TDES";
            }
            return "CTR-DRBG-" + this.a.getAlgorithmName() + this.b;
        }

        @Override
        public SP80090DRBG a(EntropySource entropySource) {
            return new CTRSP800DRBG(this.a, this.b, this.e, entropySource, this.d, this.c);
        }
    }

    private static class b
    implements com.enterprisedt.bouncycastle.crypto.prng.a {
        private final Mac a;
        private final byte[] b;
        private final byte[] c;
        private final int d;

        public b(Mac mac, byte[] byArray, byte[] byArray2, int n2) {
            this.a = mac;
            this.b = byArray;
            this.c = byArray2;
            this.d = n2;
        }

        @Override
        public String a() {
            if (this.a instanceof HMac) {
                return "HMAC-DRBG-" + SP800SecureRandomBuilder.b(((HMac)this.a).getUnderlyingDigest());
            }
            return "HMAC-DRBG-" + this.a.getAlgorithmName();
        }

        @Override
        public SP80090DRBG a(EntropySource entropySource) {
            return new HMacSP800DRBG(this.a, this.d, entropySource, this.c, this.b);
        }
    }

    private static class c
    implements com.enterprisedt.bouncycastle.crypto.prng.a {
        private final Digest a;
        private final byte[] b;
        private final byte[] c;
        private final int d;

        public c(Digest digest, byte[] byArray, byte[] byArray2, int n2) {
            this.a = digest;
            this.b = byArray;
            this.c = byArray2;
            this.d = n2;
        }

        @Override
        public String a() {
            return "HASH-DRBG-" + SP800SecureRandomBuilder.b(this.a);
        }

        @Override
        public SP80090DRBG a(EntropySource entropySource) {
            return new HashSP800DRBG(this.a, this.d, entropySource, this.c, this.b);
        }
    }
}

