/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DSAExt;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.a;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSAExt {
    private boolean a;
    private ECKeyParameters b;
    private SecureRandom c;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.a = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.c = parametersWithRandom.getRandom();
                this.b = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.c = CryptoServicesRegistrar.getSecureRandom();
                this.b = (ECPrivateKeyParameters)param;
            }
        } else {
            this.b = (ECPublicKeyParameters)param;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("ECNR", this.b, forSigning));
    }

    @Override
    public BigInteger getOrder() {
        return this.b.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] digest) {
        Object object;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair;
        Object object2;
        BigInteger[] bigIntegerArray;
        if (!this.a) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger bigInteger = this.getOrder();
        BigInteger bigInteger2 = new BigInteger(1, digest);
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.b;
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new DataLengthException("input too large for ECNR key");
        }
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        do {
            object = new ECKeyPairGenerator();
            ((ECKeyPairGenerator)object).init(new ECKeyGenerationParameters(eCPrivateKeyParameters.getParameters(), this.c));
        } while ((bigInteger3 = (bigIntegerArray = ((ECPublicKeyParameters)(object2 = (ECPublicKeyParameters)(asymmetricCipherKeyPair = ((ECKeyPairGenerator)object).generateKeyPair()).getPublic())).getQ().getAffineXCoord().toBigInteger()).add(bigInteger2).mod(bigInteger)).equals(ECConstants.ZERO));
        object = eCPrivateKeyParameters.getD();
        object2 = ((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getD();
        bigInteger4 = ((BigInteger)object2).subtract(bigInteger3.multiply((BigInteger)object)).mod(bigInteger);
        bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    @Override
    public boolean verifySignature(byte[] digest, BigInteger r2, BigInteger s2) {
        if (this.a) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.b;
        BigInteger bigInteger = eCPublicKeyParameters.getParameters().getN();
        int n2 = bigInteger.bitLength();
        BigInteger bigInteger2 = new BigInteger(1, digest);
        int n3 = bigInteger2.bitLength();
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger bigInteger3 = this.a(eCPublicKeyParameters, r2, s2);
        return bigInteger3 != null && bigInteger3.equals(bigInteger2.mod(bigInteger));
    }

    public byte[] getRecoveredMessage(BigInteger r2, BigInteger s2) {
        if (this.a) {
            throw new IllegalStateException("not initialised for verifying/recovery");
        }
        BigInteger bigInteger = this.a((ECPublicKeyParameters)this.b, r2, s2);
        if (bigInteger != null) {
            return BigIntegers.asUnsignedByteArray(bigInteger);
        }
        return null;
    }

    private BigInteger a(ECPublicKeyParameters eCPublicKeyParameters, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        BigInteger bigInteger3 = eCPublicKeyParameters.getParameters().getN();
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return null;
        }
        if (bigInteger2.compareTo(ECConstants.ZERO) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return null;
        }
        ECPoint eCPoint2 = eCPublicKeyParameters.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger2, eCPoint = eCPublicKeyParameters.getQ(), bigInteger).normalize();
        if (eCPoint3.isInfinity()) {
            return null;
        }
        BigInteger bigInteger4 = eCPoint3.getAffineXCoord().toBigInteger();
        return bigInteger.subtract(bigInteger4).mod(bigInteger3);
    }
}

