/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;

public class Ed448Signer
implements Signer {
    private final a a = new a();
    private final byte[] b;
    private boolean c;
    private Ed448PrivateKeyParameters d;
    private Ed448PublicKeyParameters e;

    public Ed448Signer(byte[] context) {
        if (null == context) {
            throw new NullPointerException("'context' cannot be null");
        }
        this.b = Arrays.clone(context);
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.c = forSigning;
        if (forSigning) {
            this.d = (Ed448PrivateKeyParameters)parameters;
            this.e = null;
        } else {
            this.d = null;
            this.e = (Ed448PublicKeyParameters)parameters;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("Ed448", 224, parameters, forSigning));
        this.reset();
    }

    @Override
    public void update(byte b2) {
        this.a.write(b2);
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        this.a.write(buf, off, len);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c || null == this.d) {
            throw new IllegalStateException("Ed448Signer not initialised for signature generation.");
        }
        return this.a.a(this.d, this.b);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c || null == this.e) {
            throw new IllegalStateException("Ed448Signer not initialised for verification");
        }
        return this.a.a(this.e, this.b, signature);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    private static final class a
    extends ByteArrayOutputStream {
        private a() {
        }

        synchronized byte[] a(Ed448PrivateKeyParameters ed448PrivateKeyParameters, byte[] byArray) {
            byte[] byArray2 = new byte[114];
            ed448PrivateKeyParameters.sign(0, byArray, this.buf, 0, this.count, byArray2, 0);
            this.reset();
            return byArray2;
        }

        synchronized boolean a(Ed448PublicKeyParameters ed448PublicKeyParameters, byte[] byArray, byte[] byArray2) {
            if (114 != byArray2.length) {
                this.reset();
                return false;
            }
            boolean bl = ed448PublicKeyParameters.verify(0, byArray, this.buf, 0, this.count, byArray2, 0);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

