/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DSAExt;
import com.enterprisedt.bouncycastle.crypto.params.GOST3410KeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.GOST3410Parameters;
import com.enterprisedt.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410Signer
implements DSAExt {
    GOST3410KeyParameters a;
    SecureRandom b;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.b = parametersWithRandom.getRandom();
                this.a = (GOST3410PrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.b = CryptoServicesRegistrar.getSecureRandom();
                this.a = (GOST3410PrivateKeyParameters)param;
            }
        } else {
            this.a = (GOST3410PublicKeyParameters)param;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("GOST3410", this.a, forSigning));
    }

    @Override
    public BigInteger getOrder() {
        return this.a.getParameters().getQ();
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger bigInteger;
        byte[] byArray = Arrays.reverse(message);
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        GOST3410Parameters gOST3410Parameters = this.a.getParameters();
        while ((bigInteger = BigIntegers.createRandomBigInteger(gOST3410Parameters.getQ().bitLength(), this.b)).compareTo(gOST3410Parameters.getQ()) >= 0) {
        }
        BigInteger bigInteger3 = gOST3410Parameters.getA().modPow(bigInteger, gOST3410Parameters.getP()).mod(gOST3410Parameters.getQ());
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger2).add(((GOST3410PrivateKeyParameters)this.a).getX().multiply(bigInteger3)).mod(gOST3410Parameters.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        byte[] byArray = Arrays.reverse(message);
        BigInteger bigInteger = new BigInteger(1, byArray);
        GOST3410Parameters gOST3410Parameters = this.a.getParameters();
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        if (bigInteger2.compareTo(r2) >= 0 || gOST3410Parameters.getQ().compareTo(r2) <= 0) {
            return false;
        }
        if (bigInteger2.compareTo(s2) >= 0 || gOST3410Parameters.getQ().compareTo(s2) <= 0) {
            return false;
        }
        BigInteger bigInteger3 = bigInteger.modPow(gOST3410Parameters.getQ().subtract(new BigInteger("2")), gOST3410Parameters.getQ());
        BigInteger bigInteger4 = s2.multiply(bigInteger3).mod(gOST3410Parameters.getQ());
        BigInteger bigInteger5 = gOST3410Parameters.getQ().subtract(r2).multiply(bigInteger3).mod(gOST3410Parameters.getQ());
        bigInteger4 = gOST3410Parameters.getA().modPow(bigInteger4, gOST3410Parameters.getP());
        bigInteger5 = ((GOST3410PublicKeyParameters)this.a).getY().modPow(bigInteger5, gOST3410Parameters.getP());
        BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5).mod(gOST3410Parameters.getP()).mod(gOST3410Parameters.getQ());
        return bigInteger6.equals(r2);
    }
}

