/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.NullDigest;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSABlindingParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest a;
    private Digest b;
    private Digest c;
    private AsymmetricBlockCipher d;
    private SecureRandom e;
    private int f;
    private int g;
    private boolean h;
    private int i;
    private int j;
    private byte[] k;
    private byte[] l;
    private byte[] m;
    private byte n;

    public static PSSSigner createRawSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen, byte trailer) {
        return new PSSSigner(cipher, (Digest)new NullDigest(), contentDigest, mgfDigest, sLen, trailer);
    }

    public static PSSSigner createRawSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, byte[] salt, byte trailer) {
        return new PSSSigner(cipher, (Digest)new NullDigest(), contentDigest, mgfDigest, salt, trailer);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen) {
        this(cipher, digest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen) {
        this(cipher, contentDigest, mgfDigest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen, byte trailer) {
        this(cipher, digest, digest, sLen, trailer);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen, byte trailer) {
        this(cipher, contentDigest, contentDigest, mgfDigest, sLen, trailer);
    }

    private PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest1, Digest contentDigest2, Digest mgfDigest, int sLen, byte trailer) {
        this.d = cipher;
        this.a = contentDigest1;
        this.b = contentDigest2;
        this.c = mgfDigest;
        this.f = contentDigest2.getDigestSize();
        this.g = mgfDigest.getDigestSize();
        this.h = false;
        this.i = sLen;
        this.k = new byte[sLen];
        this.l = new byte[8 + sLen + this.f];
        this.n = trailer;
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, byte[] salt) {
        this(cipher, digest, digest, salt, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, byte[] salt) {
        this(cipher, contentDigest, mgfDigest, salt, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, byte[] salt, byte trailer) {
        this(cipher, contentDigest, contentDigest, mgfDigest, salt, trailer);
    }

    private PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest1, Digest contentDigest2, Digest mgfDigest, byte[] salt, byte trailer) {
        this.d = cipher;
        this.a = contentDigest1;
        this.b = contentDigest2;
        this.c = mgfDigest;
        this.f = contentDigest2.getDigestSize();
        this.g = mgfDigest.getDigestSize();
        this.h = true;
        this.i = salt.length;
        this.k = salt;
        this.l = new byte[8 + this.i + this.f];
        this.n = trailer;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        CipherParameters cipherParameters;
        CipherParameters cipherParameters2;
        if (param instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)param;
            cipherParameters = ((ParametersWithRandom)cipherParameters2).getParameters();
            this.e = ((ParametersWithRandom)cipherParameters2).getRandom();
        } else {
            cipherParameters = param;
            if (forSigning) {
                this.e = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        if (cipherParameters instanceof RSABlindingParameters) {
            cipherParameters2 = ((RSABlindingParameters)cipherParameters).getPublicKey();
            this.d.init(forSigning, param);
        } else {
            cipherParameters2 = (RSAKeyParameters)cipherParameters;
            this.d.init(forSigning, cipherParameters);
        }
        this.j = ((RSAKeyParameters)cipherParameters2).getModulus().bitLength() - 1;
        if (this.j < 8 * this.f + 8 * this.i + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        this.m = new byte[(this.j + 7) / 8];
        this.reset();
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void update(byte b2) {
        this.a.update(b2);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.a.update(in, off, len);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        int n2;
        if (this.a.getDigestSize() != this.f) {
            throw new IllegalStateException();
        }
        this.a.doFinal(this.l, this.l.length - this.f - this.i);
        if (this.i != 0) {
            if (!this.h) {
                this.e.nextBytes(this.k);
            }
            System.arraycopy(this.k, 0, this.l, this.l.length - this.i, this.i);
        }
        byte[] byArray = new byte[this.f];
        this.b.update(this.l, 0, this.l.length);
        this.b.doFinal(byArray, 0);
        this.m[this.m.length - this.i - 1 - this.f - 1] = 1;
        System.arraycopy(this.k, 0, this.m, this.m.length - this.i - this.f - 1, this.i);
        byte[] byArray2 = this.a(byArray, 0, byArray.length, this.m.length - this.f - 1);
        for (n2 = 0; n2 != byArray2.length; ++n2) {
            int n3 = n2;
            this.m[n3] = (byte)(this.m[n3] ^ byArray2[n2]);
        }
        System.arraycopy(byArray, 0, this.m, this.m.length - this.f - 1, this.f);
        n2 = 255 >>> this.m.length * 8 - this.j;
        this.m[0] = (byte)(this.m[0] & n2);
        this.m[this.m.length - 1] = this.n;
        byte[] byArray3 = this.d.processBlock(this.m, 0, this.m.length);
        this.a(this.m);
        return byArray3;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        int n2;
        if (this.a.getDigestSize() != this.f) {
            throw new IllegalStateException();
        }
        this.a.doFinal(this.l, this.l.length - this.f - this.i);
        try {
            byte[] byArray = this.d.processBlock(signature, 0, signature.length);
            Arrays.fill(this.m, 0, this.m.length - byArray.length, (byte)0);
            System.arraycopy(byArray, 0, this.m, this.m.length - byArray.length, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        int n3 = 255 >>> this.m.length * 8 - this.j;
        if ((this.m[0] & 0xFF) != (this.m[0] & n3) || this.m[this.m.length - 1] != this.n) {
            this.a(this.m);
            return false;
        }
        byte[] byArray = this.a(this.m, this.m.length - this.f - 1, this.f, this.m.length - this.f - 1);
        for (n2 = 0; n2 != byArray.length; ++n2) {
            int n4 = n2;
            this.m[n4] = (byte)(this.m[n4] ^ byArray[n2]);
        }
        this.m[0] = (byte)(this.m[0] & n3);
        for (n2 = 0; n2 != this.m.length - this.f - this.i - 2; ++n2) {
            if (this.m[n2] == 0) continue;
            this.a(this.m);
            return false;
        }
        if (this.m[this.m.length - this.f - this.i - 2] != 1) {
            this.a(this.m);
            return false;
        }
        if (this.h) {
            System.arraycopy(this.k, 0, this.l, this.l.length - this.i, this.i);
        } else {
            System.arraycopy(this.m, this.m.length - this.i - this.f - 1, this.l, this.l.length - this.i, this.i);
        }
        this.b.update(this.l, 0, this.l.length);
        this.b.doFinal(this.l, this.l.length - this.f);
        n2 = this.m.length - this.f - 1;
        for (int i2 = this.l.length - this.f; i2 != this.l.length; ++i2) {
            if ((this.m[n2] ^ this.l[i2]) != 0) {
                this.a(this.l);
                this.a(this.m);
                return false;
            }
            ++n2;
        }
        this.a(this.l);
        this.a(this.m);
        return true;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        if (this.c instanceof Xof) {
            byte[] byArray2 = new byte[n4];
            this.c.update(byArray, n2, n3);
            ((Xof)this.c).doFinal(byArray2, 0, byArray2.length);
            return byArray2;
        }
        return this.b(byArray, n2, n3, n4);
    }

    private byte[] b(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.g];
        byte[] byArray4 = new byte[4];
        this.c.reset();
        for (n5 = 0; n5 < n4 / this.g; ++n5) {
            this.a(n5, byArray4);
            this.c.update(byArray, n2, n3);
            this.c.update(byArray4, 0, byArray4.length);
            this.c.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.g, this.g);
        }
        if (n5 * this.g < n4) {
            this.a(n5, byArray4);
            this.c.update(byArray, n2, n3);
            this.c.update(byArray4, 0, byArray4.length);
            this.c.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.g, byArray2.length - n5 * this.g);
        }
        return byArray2;
    }
}

