/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.crypto.signers.DSAEncoding;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class StandardDSAEncoding
implements DSAEncoding {
    public static final StandardDSAEncoding INSTANCE = new StandardDSAEncoding();

    @Override
    public byte[] encode(BigInteger n2, BigInteger r2, BigInteger s2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.encodeValue(n2, aSN1EncodableVector, r2);
        this.encodeValue(n2, aSN1EncodableVector, s2);
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    @Override
    public BigInteger[] decode(BigInteger n2, byte[] encoding) throws IOException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray;
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
        if (aSN1Sequence.size() == 2 && Arrays.areEqual(byArray = this.encode(n2, bigInteger2 = this.decodeValue(n2, aSN1Sequence, 0), bigInteger = this.decodeValue(n2, aSN1Sequence, 1)), encoding)) {
            return new BigInteger[]{bigInteger2, bigInteger};
        }
        throw new IllegalArgumentException("Malformed signature");
    }

    protected BigInteger checkValue(BigInteger n2, BigInteger x) {
        if (x.signum() < 0 || null != n2 && x.compareTo(n2) >= 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        return x;
    }

    protected BigInteger decodeValue(BigInteger n2, ASN1Sequence s2, int pos) {
        return this.checkValue(n2, ((ASN1Integer)s2.getObjectAt(pos)).getValue());
    }

    protected void encodeValue(BigInteger n2, ASN1EncodableVector v2, BigInteger x) {
        v2.add(new ASN1Integer(this.checkValue(n2, x)));
    }
}

