/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.ISOTrailers;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class X931Signer
implements Signer {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    public static final int TRAILER_SHA224 = 14540;
    private Digest a;
    private AsymmetricBlockCipher b;
    private RSAKeyParameters c;
    private int d;
    private int e;
    private byte[] f;

    public X931Signer(AsymmetricBlockCipher cipher, Digest digest, boolean implicit) {
        this.b = cipher;
        this.a = digest;
        if (implicit) {
            this.d = 188;
        } else {
            Integer n2 = ISOTrailers.getTrailer(digest);
            if (n2 != null) {
                this.d = n2;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public X931Signer(AsymmetricBlockCipher cipher, Digest digest) {
        this(cipher, digest, false);
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.c = (RSAKeyParameters)param;
        this.b.init(forSigning, this.c);
        this.e = this.c.getModulus().bitLength();
        this.f = new byte[(this.e + 7) / 8];
        this.reset();
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void update(byte b2) {
        this.a.update(b2);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.a.update(in, off, len);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        this.a(this.d);
        BigInteger bigInteger = new BigInteger(1, this.b.processBlock(this.f, 0, this.f.length));
        this.a(this.f);
        bigInteger = bigInteger.min(this.c.getModulus().subtract(bigInteger));
        int n2 = BigIntegers.getUnsignedByteLength(this.c.getModulus());
        return BigIntegers.asUnsignedByteArray(n2, bigInteger);
    }

    private void a(int n2) {
        int n3;
        int n4 = this.a.getDigestSize();
        if (n2 == 188) {
            n3 = this.f.length - n4 - 1;
            this.a.doFinal(this.f, n3);
            this.f[this.f.length - 1] = -68;
        } else {
            n3 = this.f.length - n4 - 2;
            this.a.doFinal(this.f, n3);
            this.f[this.f.length - 2] = (byte)(n2 >>> 8);
            this.f[this.f.length - 1] = (byte)n2;
        }
        this.f[0] = 107;
        for (int i2 = n3 - 2; i2 != 0; --i2) {
            this.f[i2] = -69;
        }
        this.f[n3 - 1] = -70;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        BigInteger bigInteger;
        try {
            this.f = this.b.processBlock(signature, 0, signature.length);
        }
        catch (Exception exception) {
            return false;
        }
        BigInteger bigInteger2 = new BigInteger(1, this.f);
        if ((bigInteger2.intValue() & 0xF) == 12) {
            bigInteger = bigInteger2;
        } else {
            bigInteger2 = this.c.getModulus().subtract(bigInteger2);
            if ((bigInteger2.intValue() & 0xF) == 12) {
                bigInteger = bigInteger2;
            } else {
                return false;
            }
        }
        this.a(this.d);
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.f.length, bigInteger);
        boolean bl = Arrays.constantTimeAreEqual(this.f, byArray);
        if (this.d == 15052 && !bl) {
            this.f[this.f.length - 2] = 64;
            bl = Arrays.constantTimeAreEqual(this.f, byArray);
        }
        this.a(this.f);
        this.a(byArray);
        return bl;
    }
}

