/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.enterprisedt.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.enterprisedt.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.sec.ECPrivateKey;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.DSAParameter;
import com.enterprisedt.bouncycastle.asn1.x9.X962Parameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECPoint;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class PrivateKeyInfoFactory {
    private static Set a = new HashSet(5);

    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(privateKey, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey, ASN1Set attributes) throws IOException {
        if (privateKey instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(rSAPrivateCrtKeyParameters.getModulus(), rSAPrivateCrtKeyParameters.getPublicExponent(), rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ(), rSAPrivateCrtKeyParameters.getDP(), rSAPrivateCrtKeyParameters.getDQ(), rSAPrivateCrtKeyParameters.getQInv()), attributes);
        }
        if (privateKey instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)privateKey;
            DSAParameters dSAParameters = dSAPrivateKeyParameters.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG())), new ASN1Integer(dSAPrivateKeyParameters.getX()), attributes);
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            Object object;
            int n2;
            X962Parameters x962Parameters;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)privateKey;
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            if (eCDomainParameters == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
                n2 = eCPrivateKeyParameters.getD().bitLength();
            } else {
                if (eCDomainParameters instanceof ECGOST3410Parameters) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier;
                    int n3;
                    GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(((ECGOST3410Parameters)eCDomainParameters).getPublicKeyParamSet(), ((ECGOST3410Parameters)eCDomainParameters).getDigestParamSet(), ((ECGOST3410Parameters)eCDomainParameters).getEncryptionParamSet());
                    if (a.contains(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet())) {
                        n3 = 32;
                        aSN1ObjectIdentifier = CryptoProObjectIdentifiers.gostR3410_2001;
                    } else {
                        boolean bl = eCPrivateKeyParameters.getD().bitLength() > 256;
                        aSN1ObjectIdentifier = bl ? RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512 : RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
                        n3 = bl ? 64 : 32;
                    }
                    byte[] byArray = new byte[n3];
                    PrivateKeyInfoFactory.a(byArray, n3, 0, eCPrivateKeyParameters.getD());
                    return new PrivateKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
                }
                if (eCDomainParameters instanceof ECNamedDomainParameters) {
                    x962Parameters = new X962Parameters(((ECNamedDomainParameters)eCDomainParameters).getName());
                    n2 = eCDomainParameters.getN().bitLength();
                } else {
                    object = new X9ECParameters(eCDomainParameters.getCurve(), new X9ECPoint(eCDomainParameters.getG(), false), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
                    x962Parameters = new X962Parameters((X9ECParameters)object);
                    n2 = eCDomainParameters.getN().bitLength();
                }
            }
            object = new FixedPointCombMultiplier().multiply(eCDomainParameters.getG(), eCPrivateKeyParameters.getD());
            DERBitString dERBitString = new DERBitString(((ECPoint)object).getEncoded(false));
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKey(n2, eCPrivateKeyParameters.getD(), dERBitString, x962Parameters), attributes);
        }
        if (privateKey instanceof X448PrivateKeyParameters) {
            X448PrivateKeyParameters x448PrivateKeyParameters = (X448PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), new DEROctetString(x448PrivateKeyParameters.getEncoded()), attributes, x448PrivateKeyParameters.generatePublicKey().getEncoded());
        }
        if (privateKey instanceof X25519PrivateKeyParameters) {
            X25519PrivateKeyParameters x25519PrivateKeyParameters = (X25519PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(x25519PrivateKeyParameters.getEncoded()), attributes, x25519PrivateKeyParameters.generatePublicKey().getEncoded());
        }
        if (privateKey instanceof Ed448PrivateKeyParameters) {
            Ed448PrivateKeyParameters ed448PrivateKeyParameters = (Ed448PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), new DEROctetString(ed448PrivateKeyParameters.getEncoded()), attributes, ed448PrivateKeyParameters.generatePublicKey().getEncoded());
        }
        if (privateKey instanceof Ed25519PrivateKeyParameters) {
            Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = (Ed25519PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), new DEROctetString(ed25519PrivateKeyParameters.getEncoded()), attributes, ed25519PrivateKeyParameters.generatePublicKey().getEncoded());
        }
        throw new IOException("key parameters not recognized");
    }

    private static void a(byte[] byArray, int n2, int n3, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < n2) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != n2; ++i2) {
            byArray[n3 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    static {
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

