/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.enterprisedt.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.enterprisedt.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.oiw.ElGamalParameter;
import com.enterprisedt.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.DHParameter;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.enterprisedt.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145ECBinary;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145Params;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.enterprisedt.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.DSAParameter;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.DHPublicKey;
import com.enterprisedt.bouncycastle.asn1.x9.DomainParameters;
import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.ValidationParams;
import com.enterprisedt.bouncycastle.asn1.x9.X962Parameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECPoint;
import com.enterprisedt.bouncycastle.asn1.x9.X9IntegerConverter;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHValidationParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ElGamalParameters;
import com.enterprisedt.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class PublicKeyFactory {
    private static Map a = new HashMap();

    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        if (keyInfoData == null) {
            throw new IllegalArgumentException("keyInfoData array null");
        }
        if (keyInfoData.length == 0) {
            throw new IllegalArgumentException("keyInfoData array empty");
        }
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo argument null");
        }
        return PublicKeyFactory.createKey(keyInfo, null);
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo argument null");
        }
        AlgorithmIdentifier algorithmIdentifier = keyInfo.getAlgorithm();
        l l2 = (l)a.get(algorithmIdentifier.getAlgorithm());
        if (null == l2) {
            throw new IOException("algorithm identifier in public key not recognised: " + algorithmIdentifier.getAlgorithm());
        }
        return l2.a(keyInfo, defaultParams);
    }

    private static byte[] b(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
        return subjectPublicKeyInfo.getPublicKeyData().getOctets();
    }

    static {
        a.put(PKCSObjectIdentifiers.rsaEncryption, new k());
        a.put(PKCSObjectIdentifiers.id_RSASSA_PSS, new k());
        a.put(X509ObjectIdentifiers.id_ea_rsa, new k());
        a.put(X9ObjectIdentifiers.dhpublicnumber, new b());
        a.put(PKCSObjectIdentifiers.dhKeyAgreement, new a());
        a.put(X9ObjectIdentifiers.id_dsa, new c());
        a.put(OIWObjectIdentifiers.dsaWithSHA1, new c());
        a.put(OIWObjectIdentifiers.elGamalAlgorithm, new h());
        a.put(X9ObjectIdentifiers.id_ecPublicKey, new e());
        a.put(CryptoProObjectIdentifiers.gostR3410_2001, new i());
        a.put(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256, new j());
        a.put(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512, new j());
        a.put(UAObjectIdentifiers.dstu4145be, new d());
        a.put(UAObjectIdentifiers.dstu4145le, new d());
        a.put(EdECObjectIdentifiers.id_X25519, new m());
        a.put(EdECObjectIdentifiers.id_X448, new n());
        a.put(EdECObjectIdentifiers.id_Ed25519, new f());
        a.put(EdECObjectIdentifiers.id_Ed448, new g());
    }

    private static class g
    extends l {
        private g() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new Ed448PublicKeyParameters(PublicKeyFactory.b(subjectPublicKeyInfo, object));
        }
    }

    private static class f
    extends l {
        private f() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new Ed25519PublicKeyParameters(PublicKeyFactory.b(subjectPublicKeyInfo, object));
        }
    }

    private static class n
    extends l {
        private n() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new X448PublicKeyParameters(PublicKeyFactory.b(subjectPublicKeyInfo, object));
        }
    }

    private static class m
    extends l {
        private m() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new X25519PublicKeyParameters(PublicKeyFactory.b(subjectPublicKeyInfo, object));
        }
    }

    private static class d
    extends l {
        private d() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            Object object2;
            ECDomainParameters eCDomainParameters;
            ASN1OctetString aSN1OctetString;
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            DSTU4145Params dSTU4145Params = DSTU4145Params.getInstance(algorithmIdentifier.getParameters());
            try {
                aSN1OctetString = (ASN1OctetString)subjectPublicKeyInfo.parsePublicKey();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering DSTU public key");
            }
            byte[] byArray = Arrays.clone(aSN1OctetString.getOctets());
            if (aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145le)) {
                this.a(byArray);
            }
            if (dSTU4145Params.isNamedCurve()) {
                eCDomainParameters = DSTU4145NamedCurves.getByOID(dSTU4145Params.getNamedCurve());
            } else {
                object2 = dSTU4145Params.getECBinary();
                byte[] byArray2 = ((DSTU4145ECBinary)object2).getB();
                if (aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145le)) {
                    this.a(byArray2);
                }
                BigInteger bigInteger = new BigInteger(1, byArray2);
                DSTU4145BinaryField dSTU4145BinaryField = ((DSTU4145ECBinary)object2).getField();
                ECCurve.F2m f2m = new ECCurve.F2m(dSTU4145BinaryField.getM(), dSTU4145BinaryField.getK1(), dSTU4145BinaryField.getK2(), dSTU4145BinaryField.getK3(), ((DSTU4145ECBinary)object2).getA(), bigInteger, null, null);
                byte[] byArray3 = ((DSTU4145ECBinary)object2).getG();
                if (aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145le)) {
                    this.a(byArray3);
                }
                ECPoint eCPoint = DSTU4145PointEncoder.decodePoint(f2m, byArray3);
                eCDomainParameters = new ECDomainParameters(f2m, eCPoint, ((DSTU4145ECBinary)object2).getN());
            }
            object2 = DSTU4145PointEncoder.decodePoint(eCDomainParameters.getCurve(), byArray);
            return new ECPublicKeyParameters((ECPoint)object2, eCDomainParameters);
        }

        private void a(byte[] byArray) {
            for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
                byte by = byArray[i2];
                byArray[i2] = byArray[byArray.length - 1 - i2];
                byArray[byArray.length - 1 - i2] = by;
            }
        }
    }

    private static class j
    extends l {
        private j() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            ASN1OctetString aSN1OctetString;
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance(algorithmIdentifier.getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = gOST3410PublicKeyAlgParameters.getPublicKeyParamSet();
            ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(new ECNamedDomainParameters(aSN1ObjectIdentifier2, ECGOST3410NamedCurves.getByOIDX9(aSN1ObjectIdentifier2)), aSN1ObjectIdentifier2, gOST3410PublicKeyAlgParameters.getDigestParamSet(), gOST3410PublicKeyAlgParameters.getEncryptionParamSet());
            try {
                aSN1OctetString = (ASN1OctetString)subjectPublicKeyInfo.parsePublicKey();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering GOST3410_2012 public key");
            }
            int n2 = 32;
            if (aSN1ObjectIdentifier.equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512)) {
                n2 = 64;
            }
            int n3 = 2 * n2;
            byte[] byArray = aSN1OctetString.getOctets();
            if (byArray.length != n3) {
                throw new IllegalArgumentException("invalid length for GOST3410_2012 public key");
            }
            byte[] byArray2 = new byte[1 + n3];
            byArray2[0] = 4;
            for (int i2 = 1; i2 <= n2; ++i2) {
                byArray2[i2] = byArray[n2 - i2];
                byArray2[i2 + n2] = byArray[n3 - i2];
            }
            ECPoint eCPoint = eCGOST3410Parameters.getCurve().decodePoint(byArray2);
            return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)eCGOST3410Parameters);
        }
    }

    private static class i
    extends l {
        private i() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            ASN1OctetString aSN1OctetString;
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance(algorithmIdentifier.getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = gOST3410PublicKeyAlgParameters.getPublicKeyParamSet();
            ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(new ECNamedDomainParameters(aSN1ObjectIdentifier, ECGOST3410NamedCurves.getByOIDX9(aSN1ObjectIdentifier)), aSN1ObjectIdentifier, gOST3410PublicKeyAlgParameters.getDigestParamSet(), gOST3410PublicKeyAlgParameters.getEncryptionParamSet());
            try {
                aSN1OctetString = (ASN1OctetString)subjectPublicKeyInfo.parsePublicKey();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering GOST3410_2001 public key");
            }
            int n2 = 32;
            int n3 = 2 * n2;
            byte[] byArray = aSN1OctetString.getOctets();
            if (byArray.length != n3) {
                throw new IllegalArgumentException("invalid length for GOST3410_2001 public key");
            }
            byte[] byArray2 = new byte[1 + n3];
            byArray2[0] = 4;
            for (int i2 = 1; i2 <= n2; ++i2) {
                byArray2[i2] = byArray[n2 - i2];
                byArray2[i2 + n2] = byArray[n3 - i2];
            }
            ECPoint eCPoint = eCGOST3410Parameters.getCurve().decodePoint(byArray2);
            return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)eCGOST3410Parameters);
        }
    }

    private static class e
    extends l {
        private e() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            int n2;
            ECDomainParameters eCDomainParameters;
            Object object2;
            ASN1Object aSN1Object;
            X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Object = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                object2 = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Object);
                if (object2 == null) {
                    object2 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1Object);
                }
                eCDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)aSN1Object, (X9ECParameters)object2);
            } else if (x962Parameters.isImplicitlyCA()) {
                eCDomainParameters = (ECDomainParameters)object;
            } else {
                aSN1Object = X9ECParameters.getInstance(x962Parameters.getParameters());
                eCDomainParameters = new ECDomainParameters((X9ECParameters)aSN1Object);
            }
            aSN1Object = subjectPublicKeyInfo.getPublicKeyData();
            object2 = ((ASN1BitString)aSN1Object).getBytes();
            ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object2);
            if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3) && (n2 = new X9IntegerConverter().getByteLength(eCDomainParameters.getCurve())) >= ((Object)object2).length - 3) {
                try {
                    aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object2);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint x9ECPoint = new X9ECPoint(eCDomainParameters.getCurve(), aSN1OctetString);
            return new ECPublicKeyParameters(x9ECPoint.getPoint(), eCDomainParameters);
        }
    }

    private static class c
    extends l {
        private c() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            ASN1Encodable aSN1Encodable = subjectPublicKeyInfo.getAlgorithm().getParameters();
            DSAParameters dSAParameters = null;
            if (aSN1Encodable != null) {
                DSAParameter dSAParameter = DSAParameter.getInstance(aSN1Encodable.toASN1Primitive());
                dSAParameters = new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            return new DSAPublicKeyParameters(aSN1Integer.getValue(), dSAParameters);
        }
    }

    private static class h
    extends l {
        private h() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            return new ElGamalPublicKeyParameters(aSN1Integer.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
    }

    private static class a
    extends l {
        private a() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            DHParameter dHParameter = DHParameter.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            BigInteger bigInteger = dHParameter.getL();
            int n2 = bigInteger == null ? 0 : bigInteger.intValue();
            DHParameters dHParameters = new DHParameters(dHParameter.getP(), dHParameter.getG(), null, n2);
            return new DHPublicKeyParameters(aSN1Integer.getValue(), dHParameters);
        }
    }

    private static class b
    extends l {
        private b() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            DHPublicKey dHPublicKey = DHPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
            BigInteger bigInteger = dHPublicKey.getY();
            DomainParameters domainParameters = DomainParameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            BigInteger bigInteger2 = domainParameters.getP();
            BigInteger bigInteger3 = domainParameters.getG();
            BigInteger bigInteger4 = domainParameters.getQ();
            BigInteger bigInteger5 = null;
            if (domainParameters.getJ() != null) {
                bigInteger5 = domainParameters.getJ();
            }
            DHValidationParameters dHValidationParameters = null;
            ValidationParams validationParams = domainParameters.getValidationParams();
            if (validationParams != null) {
                byte[] byArray = validationParams.getSeed();
                BigInteger bigInteger6 = validationParams.getPgenCounter();
                dHValidationParameters = new DHValidationParameters(byArray, bigInteger6.intValue());
            }
            return new DHPublicKeyParameters(bigInteger, new DHParameters(bigInteger2, bigInteger3, bigInteger4, bigInteger5, dHValidationParameters));
        }
    }

    private static class k
    extends l {
        private k() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
            return new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
    }

    private static abstract class l {
        private l() {
        }

        abstract AsymmetricKeyParameter a(SubjectPublicKeyInfo var1, Object var2) throws IOException;
    }
}

