/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class RadixConverter {
    private static final double a = Math.log(9.223372036854776E18);
    private final int b;
    private final BigInteger c;
    private final int d;
    private final BigInteger[] e;

    public RadixConverter(int radix, int numberOfCachedPowers) {
        this.d = radix;
        this.b = (int)Math.floor(a / Math.log(radix));
        this.c = BigInteger.valueOf(radix).pow(this.b);
        this.e = this.a(numberOfCachedPowers, this.c);
    }

    public RadixConverter(int radix) {
        this(radix, 10);
    }

    public int getRadix() {
        return this.d;
    }

    public void toEncoding(BigInteger number, int messageLength, short[] out) {
        if (number.signum() < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = messageLength - 1;
        do {
            if (number.equals(BigInteger.ZERO)) {
                out[n2--] = 0;
                continue;
            }
            BigInteger[] bigIntegerArray = number.divideAndRemainder(this.c);
            number = bigIntegerArray[0];
            n2 = this.a(bigIntegerArray[1].longValue(), n2, out);
        } while (n2 >= 0);
        if (number.signum() != 0) {
            throw new IllegalArgumentException();
        }
    }

    private int a(long l2, int n2, short[] sArray) {
        for (int i2 = 0; i2 < this.b && n2 >= 0; ++i2) {
            if (l2 == 0L) {
                sArray[n2--] = 0;
                continue;
            }
            sArray[n2--] = (short)(l2 % (long)this.d);
            l2 /= (long)this.d;
        }
        if (l2 != 0L) {
            throw new IllegalStateException("Failed to convert decimal number");
        }
        return n2;
    }

    public BigInteger fromEncoding(short[] digits) {
        BigInteger bigInteger = BigIntegers.ONE;
        BigInteger bigInteger2 = null;
        int n2 = 0;
        int n3 = digits.length;
        for (int i2 = n3 - this.b; i2 > -this.b; i2 -= this.b) {
            int n4 = this.b;
            if (i2 < 0) {
                n4 = this.b + i2;
                i2 = 0;
            }
            int n5 = Math.min(i2 + n4, n3);
            long l2 = this.a(i2, n5, digits);
            BigInteger bigInteger3 = BigInteger.valueOf(l2);
            if (n2 == 0) {
                bigInteger2 = bigInteger3;
            } else {
                bigInteger = n2 <= this.e.length ? this.e[n2 - 1] : bigInteger.multiply(this.c);
                bigInteger2 = bigInteger2.add(bigInteger3.multiply(bigInteger));
            }
            ++n2;
        }
        return bigInteger2;
    }

    public int getDigitsGroupLength() {
        return this.b;
    }

    private long a(int n2, int n3, short[] sArray) {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            l2 = l2 * (long)this.d + (long)(sArray[i2] & 0xFFFF);
        }
        return l2;
    }

    private BigInteger[] a(int n2, BigInteger bigInteger) {
        BigInteger[] bigIntegerArray = new BigInteger[n2];
        BigInteger bigInteger2 = bigInteger;
        for (int i2 = 0; i2 < n2; ++i2) {
            bigIntegerArray[i2] = bigInteger2;
            bigInteger2 = bigInteger2.multiply(bigInteger);
        }
        return bigIntegerArray;
    }
}

