/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.ECPointMap;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.FixedPointUtil;
import com.enterprisedt.bouncycastle.math.ec.WNafPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.math.ec.endo.ECEndomorphism;
import com.enterprisedt.bouncycastle.math.ec.endo.EndoUtil;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.enterprisedt.bouncycastle.math.field.FiniteField;
import com.enterprisedt.bouncycastle.math.field.PolynomialExtensionField;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import java.math.BigInteger;

public class ECAlgorithms {
    public static boolean isF2mCurve(ECCurve c2) {
        return ECAlgorithms.isF2mField(c2.getField());
    }

    public static boolean isF2mField(FiniteField field) {
        return field.getDimension() > 1 && field.getCharacteristic().equals(ECConstants.TWO) && field instanceof PolynomialExtensionField;
    }

    public static boolean isFpCurve(ECCurve c2) {
        return ECAlgorithms.isFpField(c2.getField());
    }

    public static boolean isFpField(FiniteField field) {
        return field.getDimension() == 1;
    }

    public static ECPoint sumOfMultiplies(ECPoint[] ps, BigInteger[] ks) {
        if (ps == null || ks == null || ps.length != ks.length || ps.length < 1) {
            throw new IllegalArgumentException("point and scalar arrays should be non-null, and of equal, non-zero, length");
        }
        int n2 = ps.length;
        switch (n2) {
            case 1: {
                return ps[0].multiply(ks[0]);
            }
            case 2: {
                return ECAlgorithms.sumOfTwoMultiplies(ps[0], ks[0], ps[1], ks[1]);
            }
        }
        ECPoint eCPoint = ps[0];
        ECCurve eCCurve = eCPoint.getCurve();
        ECPoint[] eCPointArray = new ECPoint[n2];
        eCPointArray[0] = eCPoint;
        for (int i2 = 1; i2 < n2; ++i2) {
            eCPointArray[i2] = ECAlgorithms.importPoint(eCCurve, ps[i2]);
        }
        ECEndomorphism eCEndomorphism = eCCurve.getEndomorphism();
        if (eCEndomorphism instanceof GLVEndomorphism) {
            return ECAlgorithms.a(ECAlgorithms.a(eCPointArray, ks, (GLVEndomorphism)eCEndomorphism));
        }
        return ECAlgorithms.a(ECAlgorithms.a(eCPointArray, ks));
    }

    public static ECPoint sumOfTwoMultiplies(ECPoint P, BigInteger a2, ECPoint Q, BigInteger b2) {
        Object object;
        ECCurve eCCurve = P.getCurve();
        Q = ECAlgorithms.importPoint(eCCurve, Q);
        if (eCCurve instanceof ECCurve.AbstractF2m && ((ECCurve.AbstractF2m)(object = (ECCurve.AbstractF2m)eCCurve)).isKoblitz()) {
            return ECAlgorithms.a(P.multiply(a2).add(Q.multiply(b2)));
        }
        object = eCCurve.getEndomorphism();
        if (object instanceof GLVEndomorphism) {
            return ECAlgorithms.a(ECAlgorithms.a(new ECPoint[]{P, Q}, new BigInteger[]{a2, b2}, (GLVEndomorphism)object));
        }
        return ECAlgorithms.a(ECAlgorithms.b(P, a2, Q, b2));
    }

    public static ECPoint shamirsTrick(ECPoint P, BigInteger k2, ECPoint Q, BigInteger l2) {
        ECCurve eCCurve = P.getCurve();
        Q = ECAlgorithms.importPoint(eCCurve, Q);
        return ECAlgorithms.a(ECAlgorithms.a(P, k2, Q, l2));
    }

    public static ECPoint importPoint(ECCurve c2, ECPoint p2) {
        ECCurve eCCurve = p2.getCurve();
        if (!c2.equals(eCCurve)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return c2.importPoint(p2);
    }

    public static void montgomeryTrick(ECFieldElement[] zs, int off, int len) {
        ECAlgorithms.montgomeryTrick(zs, off, len, null);
    }

    public static void montgomeryTrick(ECFieldElement[] zs, int off, int len, ECFieldElement scale) {
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[len];
        eCFieldElementArray[0] = zs[off];
        int n2 = 0;
        while (++n2 < len) {
            eCFieldElementArray[n2] = eCFieldElementArray[n2 - 1].multiply(zs[off + n2]);
        }
        --n2;
        if (scale != null) {
            eCFieldElementArray[n2] = eCFieldElementArray[n2].multiply(scale);
        }
        ECFieldElement eCFieldElement = eCFieldElementArray[n2].invert();
        while (n2 > 0) {
            int n3 = off + n2--;
            ECFieldElement eCFieldElement2 = zs[n3];
            zs[n3] = eCFieldElementArray[n2].multiply(eCFieldElement);
            eCFieldElement = eCFieldElement.multiply(eCFieldElement2);
        }
        zs[off] = eCFieldElement;
    }

    public static ECPoint referenceMultiply(ECPoint p2, BigInteger k2) {
        BigInteger bigInteger = k2.abs();
        ECPoint eCPoint = p2.getCurve().getInfinity();
        int n2 = bigInteger.bitLength();
        if (n2 > 0) {
            if (bigInteger.testBit(0)) {
                eCPoint = p2;
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                p2 = p2.twice();
                if (!bigInteger.testBit(i2)) continue;
                eCPoint = eCPoint.add(p2);
            }
        }
        return k2.signum() < 0 ? eCPoint.negate() : eCPoint;
    }

    public static ECPoint validatePoint(ECPoint p2) {
        if (!p2.isValid()) {
            throw new IllegalStateException("Invalid point");
        }
        return p2;
    }

    public static ECPoint cleanPoint(ECCurve c2, ECPoint p2) {
        ECCurve eCCurve = p2.getCurve();
        if (!c2.equals(eCCurve)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return c2.decodePoint(p2.getEncoded(false));
    }

    static ECPoint a(ECPoint eCPoint) {
        if (!eCPoint.a()) {
            throw new IllegalStateException("Invalid result");
        }
        return eCPoint;
    }

    static ECPoint a(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve eCCurve = eCPoint.getCurve();
        ECPoint eCPoint3 = eCCurve.getInfinity();
        ECPoint eCPoint4 = eCPoint.add(eCPoint2);
        ECPoint eCPoint5 = eCPoint.subtract(eCPoint2);
        ECPoint[] eCPointArray = new ECPoint[]{eCPoint2, eCPoint5, eCPoint, eCPoint4};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint[] eCPointArray2 = new ECPoint[]{eCPointArray[3].negate(), eCPointArray[2].negate(), eCPointArray[1].negate(), eCPointArray[0].negate(), eCPoint3, eCPointArray[0], eCPointArray[1], eCPointArray[2], eCPointArray[3]};
        byte[] byArray = WNafUtil.generateJSF(bigInteger, bigInteger2);
        ECPoint eCPoint6 = eCPoint3;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            byte by = byArray[n2];
            int n3 = by << 24 >> 28;
            int n4 = by << 28 >> 28;
            int n5 = 4 + n3 * 3 + n4;
            eCPoint6 = eCPoint6.twicePlus(eCPointArray2[n5]);
        }
        return eCPoint6;
    }

    static ECPoint b(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = bigInteger2.signum() < 0;
        BigInteger bigInteger3 = bigInteger.abs();
        BigInteger bigInteger4 = bigInteger2.abs();
        int n2 = WNafUtil.getWindowSize(bigInteger3.bitLength(), 8);
        int n3 = WNafUtil.getWindowSize(bigInteger4.bitLength(), 8);
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n2, true);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precompute(eCPoint2, n3, true);
        ECCurve eCCurve = eCPoint.getCurve();
        int n4 = FixedPointUtil.getCombSize(eCCurve);
        if (!bl && !bl2 && bigInteger.bitLength() <= n4 && bigInteger2.bitLength() <= n4 && wNafPreCompInfo.isPromoted() && wNafPreCompInfo2.isPromoted()) {
            return ECAlgorithms.c(eCPoint, bigInteger, eCPoint2, bigInteger2);
        }
        int n5 = Math.min(8, wNafPreCompInfo.getWidth());
        n4 = Math.min(8, wNafPreCompInfo2.getWidth());
        ECPoint[] eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n5, bigInteger3);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n4, bigInteger4);
        return ECAlgorithms.a(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    static ECPoint a(ECEndomorphism eCEndomorphism, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = bigInteger2.signum() < 0;
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        int n2 = WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()), 8);
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n2, true);
        ECPoint eCPoint2 = EndoUtil.mapPoint(eCEndomorphism, eCPoint);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precomputeWithPointMap(eCPoint2, eCEndomorphism.getPointMap(), wNafPreCompInfo, true);
        int n3 = Math.min(8, wNafPreCompInfo.getWidth());
        int n4 = Math.min(8, wNafPreCompInfo2.getWidth());
        ECPoint[] eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n3, bigInteger);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n4, bigInteger2);
        return ECAlgorithms.a(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    private static ECPoint a(ECPoint[] eCPointArray, ECPoint[] eCPointArray2, byte[] byArray, ECPoint[] eCPointArray3, ECPoint[] eCPointArray4, byte[] byArray2) {
        ECPoint eCPoint;
        int n2 = Math.max(byArray.length, byArray2.length);
        ECCurve eCCurve = eCPointArray[0].getCurve();
        ECPoint eCPoint2 = eCPoint = eCCurve.getInfinity();
        int n3 = 0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ECPoint[] eCPointArray5;
            int n4;
            byte by;
            byte by2 = i2 < byArray.length ? byArray[i2] : (byte)0;
            byte by3 = by = i2 < byArray2.length ? byArray2[i2] : (byte)0;
            if ((by2 | by) == 0) {
                ++n3;
                continue;
            }
            ECPoint eCPoint3 = eCPoint;
            if (by2 != 0) {
                n4 = Math.abs(by2);
                eCPointArray5 = by2 < 0 ? eCPointArray2 : eCPointArray;
                eCPoint3 = eCPoint3.add(eCPointArray5[n4 >>> 1]);
            }
            if (by != 0) {
                n4 = Math.abs(by);
                eCPointArray5 = by < 0 ? eCPointArray4 : eCPointArray3;
                eCPoint3 = eCPoint3.add(eCPointArray5[n4 >>> 1]);
            }
            if (n3 > 0) {
                eCPoint2 = eCPoint2.timesPow2(n3);
                n3 = 0;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        if (n3 > 0) {
            eCPoint2 = eCPoint2.timesPow2(n3);
        }
        return eCPoint2;
    }

    static ECPoint a(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n2 = eCPointArray.length;
        boolean[] blArray = new boolean[n2];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n2];
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            BigInteger bigInteger = bigIntegerArray[i2];
            blArray[i2] = bigInteger.signum() < 0;
            bigInteger = bigInteger.abs();
            int n3 = WNafUtil.getWindowSize(bigInteger.bitLength(), 8);
            WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPointArray[i2], n3, true);
            int n4 = Math.min(8, wNafPreCompInfo.getWidth());
            wNafPreCompInfoArray[i2] = wNafPreCompInfo;
            byArrayArray[i2] = WNafUtil.generateWindowNaf(n4, bigInteger);
        }
        return ECAlgorithms.a(blArray, wNafPreCompInfoArray, byArrayArray);
    }

    static ECPoint a(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray, GLVEndomorphism gLVEndomorphism) {
        BigInteger bigInteger = eCPointArray[0].getCurve().getOrder();
        int n2 = eCPointArray.length;
        BigInteger[] bigIntegerArray2 = new BigInteger[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            BigInteger[] bigIntegerArray3 = gLVEndomorphism.decomposeScalar(bigIntegerArray[i2].mod(bigInteger));
            bigIntegerArray2[n3++] = bigIntegerArray3[0];
            bigIntegerArray2[n3++] = bigIntegerArray3[1];
        }
        if (gLVEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.a(gLVEndomorphism, eCPointArray, bigIntegerArray2);
        }
        ECPoint[] eCPointArray2 = new ECPoint[n2 << 1];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            ECPoint eCPoint = eCPointArray[n3];
            ECPoint eCPoint2 = EndoUtil.mapPoint(gLVEndomorphism, eCPoint);
            eCPointArray2[n4++] = eCPoint;
            eCPointArray2[n4++] = eCPoint2;
        }
        return ECAlgorithms.a(eCPointArray2, bigIntegerArray2);
    }

    static ECPoint a(ECEndomorphism eCEndomorphism, ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n2 = eCPointArray.length;
        int n3 = n2 << 1;
        boolean[] blArray = new boolean[n3];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n3];
        byte[][] byArrayArray = new byte[n3][];
        ECPointMap eCPointMap = eCEndomorphism.getPointMap();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2 << 1;
            int n5 = n4 + 1;
            BigInteger bigInteger = bigIntegerArray[n4];
            blArray[n4] = bigInteger.signum() < 0;
            bigInteger = bigInteger.abs();
            BigInteger bigInteger2 = bigIntegerArray[n5];
            blArray[n5] = bigInteger2.signum() < 0;
            bigInteger2 = bigInteger2.abs();
            int n6 = WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()), 8);
            ECPoint eCPoint = eCPointArray[i2];
            WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n6, true);
            ECPoint eCPoint2 = EndoUtil.mapPoint(eCEndomorphism, eCPoint);
            WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precomputeWithPointMap(eCPoint2, eCPointMap, wNafPreCompInfo, true);
            int n7 = Math.min(8, wNafPreCompInfo.getWidth());
            int n8 = Math.min(8, wNafPreCompInfo2.getWidth());
            wNafPreCompInfoArray[n4] = wNafPreCompInfo;
            wNafPreCompInfoArray[n5] = wNafPreCompInfo2;
            byArrayArray[n4] = WNafUtil.generateWindowNaf(n7, bigInteger);
            byArrayArray[n5] = WNafUtil.generateWindowNaf(n8, bigInteger2);
        }
        return ECAlgorithms.a(blArray, wNafPreCompInfoArray, byArrayArray);
    }

    private static ECPoint a(boolean[] blArray, WNafPreCompInfo[] wNafPreCompInfoArray, byte[][] byArray) {
        ECPoint eCPoint;
        int n2 = 0;
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = Math.max(n2, byArray[i2].length);
        }
        ECCurve eCCurve = wNafPreCompInfoArray[0].getPreComp()[0].getCurve();
        ECPoint eCPoint2 = eCPoint = eCCurve.getInfinity();
        int n4 = 0;
        for (int i3 = n2 - 1; i3 >= 0; --i3) {
            ECPoint eCPoint3 = eCPoint;
            for (int i4 = 0; i4 < n3; ++i4) {
                byte by;
                byte[] byArray2 = byArray[i4];
                byte by2 = by = i3 < byArray2.length ? byArray2[i3] : (byte)0;
                if (by == 0) continue;
                int n5 = Math.abs(by);
                WNafPreCompInfo wNafPreCompInfo = wNafPreCompInfoArray[i4];
                ECPoint[] eCPointArray = by < 0 == blArray[i4] ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
                eCPoint3 = eCPoint3.add(eCPointArray[n5 >>> 1]);
            }
            if (eCPoint3 == eCPoint) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                eCPoint2 = eCPoint2.timesPow2(n4);
                n4 = 0;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        if (n4 > 0) {
            eCPoint2 = eCPoint2.timesPow2(n4);
        }
        return eCPoint2;
    }

    private static ECPoint c(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        int n2;
        ECCurve eCCurve = eCPoint.getCurve();
        int n3 = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n3 || bigInteger2.bitLength() > n3) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint);
        FixedPointPreCompInfo fixedPointPreCompInfo2 = FixedPointUtil.precompute(eCPoint2);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        ECLookupTable eCLookupTable2 = fixedPointPreCompInfo2.getLookupTable();
        int n4 = fixedPointPreCompInfo.getWidth();
        if (n4 != (n2 = fixedPointPreCompInfo2.getWidth())) {
            FixedPointCombMultiplier fixedPointCombMultiplier = new FixedPointCombMultiplier();
            ECPoint eCPoint3 = fixedPointCombMultiplier.multiply(eCPoint, bigInteger);
            ECPoint eCPoint4 = fixedPointCombMultiplier.multiply(eCPoint2, bigInteger2);
            return eCPoint3.add(eCPoint4);
        }
        int n5 = n4;
        int n6 = (n3 + n5 - 1) / n5;
        ECPoint eCPoint5 = eCCurve.getInfinity();
        int n7 = n6 * n5;
        int[] nArray = Nat.fromBigInteger(n7, bigInteger);
        int[] nArray2 = Nat.fromBigInteger(n7, bigInteger2);
        int n8 = n7 - 1;
        for (int i2 = 0; i2 < n6; ++i2) {
            int n9 = 0;
            int n10 = 0;
            for (int i3 = n8 - i2; i3 >= 0; i3 -= n6) {
                int n11 = nArray[i3 >>> 5] >>> (i3 & 0x1F);
                n9 ^= n11 >>> 1;
                n9 <<= 1;
                n9 ^= n11;
                int n12 = nArray2[i3 >>> 5] >>> (i3 & 0x1F);
                n10 ^= n12 >>> 1;
                n10 <<= 1;
                n10 ^= n12;
            }
            ECPoint eCPoint6 = eCLookupTable.lookupVar(n9);
            ECPoint eCPoint7 = eCLookupTable2.lookupVar(n10);
            ECPoint eCPoint8 = eCPoint6.add(eCPoint7);
            eCPoint5 = eCPoint5.twicePlus(eCPoint8);
        }
        return eCPoint5.add(fixedPointPreCompInfo.getOffset()).add(fixedPointPreCompInfo2.getOffset());
    }
}

