/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement addOne();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public int bitLength() {
        return this.toBigInteger().bitLength();
    }

    public boolean isOne() {
        return this.bitLength() == 1;
    }

    public boolean isZero() {
        return 0 == this.toBigInteger().signum();
    }

    public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
        return this.multiply(b2).subtract(x.multiply(y));
    }

    public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
        return this.multiply(b2).add(x.multiply(y));
    }

    public ECFieldElement squareMinusProduct(ECFieldElement x, ECFieldElement y) {
        return this.square().subtract(x.multiply(y));
    }

    public ECFieldElement squarePlusProduct(ECFieldElement x, ECFieldElement y) {
        return this.square().add(x.multiply(y));
    }

    public ECFieldElement squarePow(int pow) {
        ECFieldElement eCFieldElement = this;
        for (int i2 = 0; i2 < pow; ++i2) {
            eCFieldElement = eCFieldElement.square();
        }
        return eCFieldElement;
    }

    public boolean testBitZero() {
        return this.toBigInteger().testBit(0);
    }

    public String toString() {
        return this.toBigInteger().toString(16);
    }

    public byte[] getEncoded() {
        return BigIntegers.asUnsignedByteArray((this.getFieldSize() + 7) / 8, this.toBigInteger());
    }

    public static class F2m
    extends AbstractF2m {
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int b;
        private int c;
        private int[] d;
        a a;

        F2m(int m2, int[] ks, a x) {
            this.c = m2;
            this.b = ks.length == 1 ? 2 : 3;
            this.d = ks;
            this.a = x;
        }

        @Override
        public int bitLength() {
            return this.a.d();
        }

        @Override
        public boolean isOne() {
            return this.a.a();
        }

        @Override
        public boolean isZero() {
            return this.a.b();
        }

        @Override
        public boolean testBitZero() {
            return this.a.g();
        }

        @Override
        public BigInteger toBigInteger() {
            return this.a.e();
        }

        @Override
        public String getFieldName() {
            return "F2m";
        }

        @Override
        public int getFieldSize() {
            return this.c;
        }

        @Override
        public ECFieldElement add(ECFieldElement b2) {
            a a2 = (a)this.a.clone();
            F2m f2m = (F2m)b2;
            a2.a(f2m.a, 0);
            return new F2m(this.c, this.d, a2);
        }

        @Override
        public ECFieldElement addOne() {
            return new F2m(this.c, this.d, this.a.f());
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b2) {
            return this.add(b2);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b2) {
            return new F2m(this.c, this.d, this.a.a(((F2m)b2).a, this.c, this.d));
        }

        @Override
        public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
            return this.multiplyPlusProduct(b2, x, y);
        }

        @Override
        public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
            a a2 = this.a;
            a a3 = ((F2m)b2).a;
            a a4 = ((F2m)x).a;
            a a5 = ((F2m)y).a;
            a a6 = a2.b(a3, this.c, this.d);
            a a7 = a4.b(a5, this.c, this.d);
            if (a6 == a2 || a6 == a3) {
                a6 = (a)a6.clone();
            }
            a6.a(a7, 0);
            a6.a(this.c, this.d);
            return new F2m(this.c, this.d, a6);
        }

        @Override
        public ECFieldElement divide(ECFieldElement b2) {
            ECFieldElement eCFieldElement = b2.invert();
            return this.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement negate() {
            return this;
        }

        @Override
        public ECFieldElement square() {
            return new F2m(this.c, this.d, this.a.b(this.c, this.d));
        }

        @Override
        public ECFieldElement squareMinusProduct(ECFieldElement x, ECFieldElement y) {
            return this.squarePlusProduct(x, y);
        }

        @Override
        public ECFieldElement squarePlusProduct(ECFieldElement x, ECFieldElement y) {
            a a2 = this.a;
            a a3 = ((F2m)x).a;
            a a4 = ((F2m)y).a;
            a a5 = a2.c(this.c, this.d);
            a a6 = a3.b(a4, this.c, this.d);
            if (a5 == a2) {
                a5 = (a)a5.clone();
            }
            a5.a(a6, 0);
            a5.a(this.c, this.d);
            return new F2m(this.c, this.d, a5);
        }

        @Override
        public ECFieldElement squarePow(int pow) {
            return pow < 1 ? this : new F2m(this.c, this.d, this.a.a(pow, this.c, this.d));
        }

        @Override
        public ECFieldElement invert() {
            return new F2m(this.c, this.d, this.a.d(this.c, this.d));
        }

        @Override
        public ECFieldElement sqrt() {
            return this.a.b() || this.a.a() ? this : this.squarePow(this.c - 1);
        }

        public int getRepresentation() {
            return this.b;
        }

        public int getM() {
            return this.c;
        }

        public int getK1() {
            return this.d[0];
        }

        public int getK2() {
            return this.d.length >= 2 ? this.d[1] : 0;
        }

        public int getK3() {
            return this.d.length >= 3 ? this.d[2] : 0;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)anObject;
            return this.c == f2m.c && this.b == f2m.b && Arrays.areEqual(this.d, f2m.d) && this.a.equals(f2m.a);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.c ^ Arrays.hashCode(this.d);
        }
    }

    public static abstract class AbstractF2m
    extends ECFieldElement {
        public ECFieldElement halfTrace() {
            int n2 = this.getFieldSize();
            if ((n2 & 1) == 0) {
                throw new IllegalStateException("Half-trace only defined for odd m");
            }
            int n3 = n2 + 1 >>> 1;
            int n4 = 31 - Integers.numberOfLeadingZeros(n3);
            int n5 = 1;
            ECFieldElement eCFieldElement = this;
            while (n4 > 0) {
                eCFieldElement = eCFieldElement.squarePow(n5 << 1).add(eCFieldElement);
                if (0 == ((n5 = n3 >>> --n4) & 1)) continue;
                eCFieldElement = eCFieldElement.squarePow(2).add(this);
            }
            return eCFieldElement;
        }

        public boolean hasFastTrace() {
            return false;
        }

        public int trace() {
            int n2 = this.getFieldSize();
            int n3 = 31 - Integers.numberOfLeadingZeros(n2);
            int n4 = 1;
            ECFieldElement eCFieldElement = this;
            while (n3 > 0) {
                eCFieldElement = eCFieldElement.squarePow(n4).add(eCFieldElement);
                if (0 == ((n4 = n2 >>> --n3) & 1)) continue;
                eCFieldElement = eCFieldElement.square().add(this);
            }
            if (eCFieldElement.isZero()) {
                return 0;
            }
            if (eCFieldElement.isOne()) {
                return 1;
            }
            throw new IllegalStateException("Internal error in trace calculation");
        }
    }

    public static class Fp
    extends AbstractFp {
        BigInteger a;
        BigInteger b;
        BigInteger c;

        static BigInteger a(BigInteger bigInteger) {
            BigInteger bigInteger2;
            int n2 = bigInteger.bitLength();
            if (n2 >= 96 && (bigInteger2 = bigInteger.shiftRight(n2 - 64)).longValue() == -1L) {
                return ONE.shiftLeft(n2).subtract(bigInteger);
            }
            return null;
        }

        Fp(BigInteger q2, BigInteger r2, BigInteger x) {
            this.a = q2;
            this.b = r2;
            this.c = x;
        }

        @Override
        public BigInteger toBigInteger() {
            return this.c;
        }

        @Override
        public String getFieldName() {
            return "Fp";
        }

        @Override
        public int getFieldSize() {
            return this.a.bitLength();
        }

        public BigInteger getQ() {
            return this.a;
        }

        @Override
        public ECFieldElement add(ECFieldElement b2) {
            return new Fp(this.a, this.b, this.modAdd(this.c, b2.toBigInteger()));
        }

        @Override
        public ECFieldElement addOne() {
            BigInteger bigInteger = this.c.add(ECConstants.ONE);
            if (bigInteger.compareTo(this.a) == 0) {
                bigInteger = ECConstants.ZERO;
            }
            return new Fp(this.a, this.b, bigInteger);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b2) {
            return new Fp(this.a, this.b, this.modSubtract(this.c, b2.toBigInteger()));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b2) {
            return new Fp(this.a, this.b, this.modMult(this.c, b2.toBigInteger()));
        }

        @Override
        public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
            BigInteger bigInteger = this.c;
            BigInteger bigInteger2 = b2.toBigInteger();
            BigInteger bigInteger3 = x.toBigInteger();
            BigInteger bigInteger4 = y.toBigInteger();
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger2);
            BigInteger bigInteger6 = bigInteger3.multiply(bigInteger4);
            return new Fp(this.a, this.b, this.modReduce(bigInteger5.subtract(bigInteger6)));
        }

        @Override
        public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
            BigInteger bigInteger = this.c;
            BigInteger bigInteger2 = b2.toBigInteger();
            BigInteger bigInteger3 = x.toBigInteger();
            BigInteger bigInteger4 = y.toBigInteger();
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger2);
            BigInteger bigInteger6 = bigInteger3.multiply(bigInteger4);
            return new Fp(this.a, this.b, this.modReduce(bigInteger5.add(bigInteger6)));
        }

        @Override
        public ECFieldElement divide(ECFieldElement b2) {
            return new Fp(this.a, this.b, this.modMult(this.c, this.modInverse(b2.toBigInteger())));
        }

        @Override
        public ECFieldElement negate() {
            return this.c.signum() == 0 ? this : new Fp(this.a, this.b, this.a.subtract(this.c));
        }

        @Override
        public ECFieldElement square() {
            return new Fp(this.a, this.b, this.modMult(this.c, this.c));
        }

        @Override
        public ECFieldElement squareMinusProduct(ECFieldElement x, ECFieldElement y) {
            BigInteger bigInteger = this.c;
            BigInteger bigInteger2 = x.toBigInteger();
            BigInteger bigInteger3 = y.toBigInteger();
            BigInteger bigInteger4 = bigInteger.multiply(bigInteger);
            BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
            return new Fp(this.a, this.b, this.modReduce(bigInteger4.subtract(bigInteger5)));
        }

        @Override
        public ECFieldElement squarePlusProduct(ECFieldElement x, ECFieldElement y) {
            BigInteger bigInteger = this.c;
            BigInteger bigInteger2 = x.toBigInteger();
            BigInteger bigInteger3 = y.toBigInteger();
            BigInteger bigInteger4 = bigInteger.multiply(bigInteger);
            BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
            return new Fp(this.a, this.b, this.modReduce(bigInteger4.add(bigInteger5)));
        }

        @Override
        public ECFieldElement invert() {
            return new Fp(this.a, this.b, this.modInverse(this.c));
        }

        @Override
        public ECFieldElement sqrt() {
            if (this.isZero() || this.isOne()) {
                return this;
            }
            if (!this.a.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.a.testBit(1)) {
                BigInteger bigInteger = this.a.shiftRight(2).add(ECConstants.ONE);
                return this.a(new Fp(this.a, this.b, this.c.modPow(bigInteger, this.a)));
            }
            if (this.a.testBit(2)) {
                BigInteger bigInteger = this.c.modPow(this.a.shiftRight(3), this.a);
                BigInteger bigInteger2 = this.modMult(bigInteger, this.c);
                BigInteger bigInteger3 = this.modMult(bigInteger2, bigInteger);
                if (bigInteger3.equals(ECConstants.ONE)) {
                    return this.a(new Fp(this.a, this.b, bigInteger2));
                }
                BigInteger bigInteger4 = ECConstants.TWO.modPow(this.a.shiftRight(2), this.a);
                BigInteger bigInteger5 = this.modMult(bigInteger2, bigInteger4);
                return this.a(new Fp(this.a, this.b, bigInteger5));
            }
            BigInteger bigInteger = this.a.shiftRight(1);
            if (!this.c.modPow(bigInteger, this.a).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger6 = this.c;
            BigInteger bigInteger7 = this.modDouble(this.modDouble(bigInteger6));
            BigInteger bigInteger8 = bigInteger.add(ECConstants.ONE);
            BigInteger bigInteger9 = this.a.subtract(ECConstants.ONE);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger10;
                if ((bigInteger10 = new BigInteger(this.a.bitLength(), random)).compareTo(this.a) >= 0 || !this.modReduce(bigInteger10.multiply(bigInteger10).subtract(bigInteger7)).modPow(bigInteger, this.a).equals(bigInteger9)) {
                    continue;
                }
                BigInteger[] bigIntegerArray = this.a(bigInteger10, bigInteger6, bigInteger8);
                BigInteger bigInteger11 = bigIntegerArray[0];
                BigInteger bigInteger12 = bigIntegerArray[1];
                if (this.modMult(bigInteger12, bigInteger12).equals(bigInteger7)) {
                    return new Fp(this.a, this.b, this.modHalfAbs(bigInteger12));
                }
                if (!bigInteger11.equals(ECConstants.ONE) && !bigInteger11.equals(bigInteger9)) break;
            }
            return null;
        }

        private ECFieldElement a(ECFieldElement eCFieldElement) {
            return eCFieldElement.square().equals(this) ? eCFieldElement : null;
        }

        private BigInteger[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            int n2;
            int n3 = bigInteger3.bitLength();
            int n4 = bigInteger3.getLowestSetBit();
            BigInteger bigInteger4 = ECConstants.ONE;
            BigInteger bigInteger5 = ECConstants.TWO;
            BigInteger bigInteger6 = bigInteger;
            BigInteger bigInteger7 = ECConstants.ONE;
            BigInteger bigInteger8 = ECConstants.ONE;
            for (n2 = n3 - 1; n2 >= n4 + 1; --n2) {
                bigInteger7 = this.modMult(bigInteger7, bigInteger8);
                if (bigInteger3.testBit(n2)) {
                    bigInteger8 = this.modMult(bigInteger7, bigInteger2);
                    bigInteger4 = this.modMult(bigInteger4, bigInteger6);
                    bigInteger5 = this.modReduce(bigInteger6.multiply(bigInteger5).subtract(bigInteger.multiply(bigInteger7)));
                    bigInteger6 = this.modReduce(bigInteger6.multiply(bigInteger6).subtract(bigInteger8.shiftLeft(1)));
                    continue;
                }
                bigInteger8 = bigInteger7;
                bigInteger4 = this.modReduce(bigInteger4.multiply(bigInteger5).subtract(bigInteger7));
                bigInteger6 = this.modReduce(bigInteger6.multiply(bigInteger5).subtract(bigInteger.multiply(bigInteger7)));
                bigInteger5 = this.modReduce(bigInteger5.multiply(bigInteger5).subtract(bigInteger7.shiftLeft(1)));
            }
            bigInteger7 = this.modMult(bigInteger7, bigInteger8);
            bigInteger8 = this.modMult(bigInteger7, bigInteger2);
            bigInteger4 = this.modReduce(bigInteger4.multiply(bigInteger5).subtract(bigInteger7));
            bigInteger5 = this.modReduce(bigInteger6.multiply(bigInteger5).subtract(bigInteger.multiply(bigInteger7)));
            bigInteger7 = this.modMult(bigInteger7, bigInteger8);
            for (n2 = 1; n2 <= n4; ++n2) {
                bigInteger4 = this.modMult(bigInteger4, bigInteger5);
                bigInteger5 = this.modReduce(bigInteger5.multiply(bigInteger5).subtract(bigInteger7.shiftLeft(1)));
                bigInteger7 = this.modMult(bigInteger7, bigInteger7);
            }
            return new BigInteger[]{bigInteger4, bigInteger5};
        }

        protected BigInteger modAdd(BigInteger x1, BigInteger x2) {
            BigInteger bigInteger = x1.add(x2);
            if (bigInteger.compareTo(this.a) >= 0) {
                bigInteger = bigInteger.subtract(this.a);
            }
            return bigInteger;
        }

        protected BigInteger modDouble(BigInteger x) {
            BigInteger bigInteger = x.shiftLeft(1);
            if (bigInteger.compareTo(this.a) >= 0) {
                bigInteger = bigInteger.subtract(this.a);
            }
            return bigInteger;
        }

        protected BigInteger modHalf(BigInteger x) {
            if (x.testBit(0)) {
                x = this.a.add(x);
            }
            return x.shiftRight(1);
        }

        protected BigInteger modHalfAbs(BigInteger x) {
            if (x.testBit(0)) {
                x = this.a.subtract(x);
            }
            return x.shiftRight(1);
        }

        protected BigInteger modInverse(BigInteger x) {
            return BigIntegers.modOddInverse(this.a, x);
        }

        protected BigInteger modMult(BigInteger x1, BigInteger x2) {
            return this.modReduce(x1.multiply(x2));
        }

        protected BigInteger modReduce(BigInteger x) {
            if (this.b != null) {
                boolean bl;
                boolean bl2 = bl = x.signum() < 0;
                if (bl) {
                    x = x.abs();
                }
                int n2 = this.a.bitLength();
                boolean bl3 = this.b.equals(ECConstants.ONE);
                while (x.bitLength() > n2 + 1) {
                    BigInteger bigInteger = x.shiftRight(n2);
                    BigInteger bigInteger2 = x.subtract(bigInteger.shiftLeft(n2));
                    if (!bl3) {
                        bigInteger = bigInteger.multiply(this.b);
                    }
                    x = bigInteger.add(bigInteger2);
                }
                while (x.compareTo(this.a) >= 0) {
                    x = x.subtract(this.a);
                }
                if (bl && x.signum() != 0) {
                    x = this.a.subtract(x);
                }
            } else {
                x = x.mod(this.a);
            }
            return x;
        }

        protected BigInteger modSubtract(BigInteger x1, BigInteger x2) {
            BigInteger bigInteger = x1.subtract(x2);
            if (bigInteger.signum() < 0) {
                bigInteger = bigInteger.add(this.a);
            }
            return bigInteger;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)other;
            return this.a.equals(fp.a) && this.c.equals(fp.c);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.c.hashCode();
        }
    }

    public static abstract class AbstractFp
    extends ECFieldElement {
    }
}

