/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.endo.EndoUtil;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve curve, GLVEndomorphism glvEndomorphism) {
        if (curve == null || curve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = curve;
        this.glvEndomorphism = glvEndomorphism;
    }

    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        if (!this.curve.equals(p2.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger bigInteger = p2.getCurve().getOrder();
        BigInteger[] bigIntegerArray = this.glvEndomorphism.decomposeScalar(k2.mod(bigInteger));
        BigInteger bigInteger2 = bigIntegerArray[0];
        BigInteger bigInteger3 = bigIntegerArray[1];
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.a(this.glvEndomorphism, p2, bigInteger2, bigInteger3);
        }
        ECPoint eCPoint = EndoUtil.mapPoint(this.glvEndomorphism, p2);
        return ECAlgorithms.b(p2, bigInteger2, eCPoint, bigInteger3);
    }
}

