/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat160;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160R1Field {
    static final int[] a = new int[]{Integer.MAX_VALUE, -1, -1, -1, -1};
    private static final int[] b = new int[]{1, 0x40000001, 0, 0, 0, -2, -2, -1, -1, -1};
    private static final int[] c = new int[]{-1, -1073741826, -1, -1, -1, 1, 1};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat160.add(x, y, z);
        if (n2 != 0 || z[4] == -1 && Nat160.gte(z, a)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(10, xx, yy, zz);
        if ((n2 != 0 || zz[9] == -1 && Nat.gte(10, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(10, zz, c.length);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(5, x, z);
        if (n2 != 0 || z[4] == -1 && Nat160.gte(z, a)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat160.fromBigInteger(x);
        if (nArray[4] == -1 && Nat160.gte(nArray, a)) {
            Nat160.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(5, x, 0, z);
        } else {
            int n2 = Nat160.add(x, a, z);
            Nat.shiftDownBit(5, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat160.createExt();
        Nat160.mul(x, y, nArray);
        SecP160R1Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat160.mulAddTo(x, y, zz);
        if ((n2 != 0 || zz[9] == -1 && Nat.gte(10, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(10, zz, c.length);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP160R1Field.isZero(x)) {
            Nat160.sub(a, a, z);
        } else {
            Nat160.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[20];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 5);
        } while (0 == Nat.lessThan(5, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP160R1Field.random(r2, z);
        } while (0 != SecP160R1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = (long)xx[5] & 0xFFFFFFFFL;
        long l3 = (long)xx[6] & 0xFFFFFFFFL;
        long l4 = (long)xx[7] & 0xFFFFFFFFL;
        long l5 = (long)xx[8] & 0xFFFFFFFFL;
        long l6 = (long)xx[9] & 0xFFFFFFFFL;
        long l7 = 0L;
        z[0] = (int)(l7 += ((long)xx[0] & 0xFFFFFFFFL) + l2 + (l2 << 31));
        l7 >>>= 32;
        z[1] = (int)(l7 += ((long)xx[1] & 0xFFFFFFFFL) + l3 + (l3 << 31));
        l7 >>>= 32;
        z[2] = (int)(l7 += ((long)xx[2] & 0xFFFFFFFFL) + l4 + (l4 << 31));
        l7 >>>= 32;
        z[3] = (int)(l7 += ((long)xx[3] & 0xFFFFFFFFL) + l5 + (l5 << 31));
        l7 >>>= 32;
        z[4] = (int)(l7 += ((long)xx[4] & 0xFFFFFFFFL) + l6 + (l6 << 31));
        SecP160R1Field.reduce32((int)(l7 >>>= 32), z);
    }

    public static void reduce32(int x, int[] z) {
        if (x != 0 && Nat160.mulWordsAdd(-2147483647, x, z, 0) != 0 || z[4] == -1 && Nat160.gte(z, a)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat160.createExt();
        Nat160.square(x, nArray);
        SecP160R1Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat160.createExt();
        Nat160.square(x, nArray);
        SecP160R1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat160.square(z, nArray);
            SecP160R1Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat160.sub(x, y, z);
        if (n2 != 0) {
            Nat.subWordFrom(5, -2147483647, z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(10, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(10, zz, c.length);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(5, x, 0, z);
        if (n2 != 0 || z[4] == -1 && Nat160.gte(z, a)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }
}

