/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256K1Field {
    static final int[] a = new int[]{-977, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] b = new int[]{954529, 1954, 1, 0, 0, 0, 0, 0, -1954, -3, -1, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{-954529, -1955, -2, -1, -1, -1, -1, -1, 1953, 2};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat256.add(x, y, z);
        if (n2 != 0 || z[7] == -1 && Nat256.gte(z, a)) {
            Nat.add33To(8, 977, z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(16, xx, yy, zz);
        if ((n2 != 0 || zz[15] == -1 && Nat.gte(16, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(16, zz, c.length);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(8, x, z);
        if (n2 != 0 || z[7] == -1 && Nat256.gte(z, a)) {
            Nat.add33To(8, 977, z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat256.fromBigInteger(x);
        if (nArray[7] == -1 && Nat256.gte(nArray, a)) {
            Nat256.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(8, x, 0, z);
        } else {
            int n2 = Nat256.add(x, a, z);
            Nat.shiftDownBit(8, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.mul(x, y, nArray);
        SecP256K1Field.reduce(nArray, z);
    }

    public static void multiply(int[] x, int[] y, int[] z, int[] tt) {
        Nat256.mul(x, y, tt);
        SecP256K1Field.reduce(tt, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat256.mulAddTo(x, y, zz);
        if ((n2 != 0 || zz[15] == -1 && Nat.gte(16, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(16, zz, c.length);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP256K1Field.isZero(x)) {
            Nat256.sub(a, a, z);
        } else {
            Nat256.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[32];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 8);
        } while (0 == Nat.lessThan(8, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP256K1Field.random(r2, z);
        } while (0 != SecP256K1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = Nat256.mul33Add(977, xx, 8, xx, 0, z, 0);
        int n2 = Nat256.mul33DWordAdd(977, l2, z, 0);
        if (n2 != 0 || z[7] == -1 && Nat256.gte(z, a)) {
            Nat.add33To(8, 977, z);
        }
    }

    public static void reduce32(int x, int[] z) {
        if (x != 0 && Nat256.mul33WordAdd(977, x, z, 0) != 0 || z[7] == -1 && Nat256.gte(z, a)) {
            Nat.add33To(8, 977, z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x, nArray);
        SecP256K1Field.reduce(nArray, z);
    }

    public static void square(int[] x, int[] z, int[] tt) {
        Nat256.square(x, tt);
        SecP256K1Field.reduce(tt, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x, nArray);
        SecP256K1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat256.square(z, nArray);
            SecP256K1Field.reduce(nArray, z);
        }
    }

    public static void squareN(int[] x, int n2, int[] z, int[] tt) {
        Nat256.square(x, tt);
        SecP256K1Field.reduce(tt, z);
        while (--n2 > 0) {
            Nat256.square(z, tt);
            SecP256K1Field.reduce(tt, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat256.sub(x, y, z);
        if (n2 != 0) {
            Nat.sub33From(8, 977, z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(16, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(16, zz, c.length);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(8, x, 0, z);
        if (n2 != 0 || z[7] == -1 && Nat256.gte(z, a)) {
            Nat.add33To(8, 977, z);
        }
    }
}

