/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT131FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT131R2Point;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT131R2Curve
extends ECCurve.AbstractF2m {
    private static final ECFieldElement[] c = new ECFieldElement[]{new SecT131FieldElement(ECConstants.ONE)};
    protected SecT131R2Point infinity = new SecT131R2Point(this, null, null);

    public SecT131R2Curve() {
        super(131, 2, 3, 8);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("03E5A88919D7CAFCBF415F07C2176573B2")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("04B8266A46C55657AC734CE38F018F2192")));
        this.order = new BigInteger(1, Hex.decodeStrict("0400000000000000016954A233049BA98F"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT131R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT131FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecT131R2Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecT131R2Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 131;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 3;
        final long[] lArray = new long[len * 3 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat192.copy64(((SecT131FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat192.copy64(((SecT131FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 3);
            n3 += 3;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] lArray3 = Nat192.create64();
                long[] lArray2 = Nat192.create64();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    long l2 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 3; ++i3) {
                        int n3 = i3;
                        lArray3[n3] = lArray3[n3] ^ lArray[n2 + i3] & l2;
                        int n4 = i3;
                        lArray2[n4] = lArray2[n4] ^ lArray[n2 + 3 + i3] & l2;
                    }
                    n2 += 6;
                }
                return this.a(lArray3, lArray2);
            }

            @Override
            public ECPoint lookupVar(int index) {
                long[] lArray3 = Nat192.create64();
                long[] lArray2 = Nat192.create64();
                int n2 = index * 3 * 2;
                for (int i2 = 0; i2 < 3; ++i2) {
                    lArray3[i2] = lArray[n2 + i2];
                    lArray2[i2] = lArray[n2 + 3 + i2];
                }
                return this.a(lArray3, lArray2);
            }

            private ECPoint a(long[] lArray3, long[] lArray2) {
                return SecT131R2Curve.this.createRawPoint(new SecT131FieldElement(lArray3), new SecT131FieldElement(lArray2), c);
            }
        };
    }
}

