/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecT193Field {
    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
        z[3] = x[3] ^ y[3];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
        zz[5] = xx[5] ^ yy[5];
        zz[6] = xx[6] ^ yy[6];
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
    }

    private static void a(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray2[0] ^ lArray[0];
        lArray2[1] = lArray2[1] ^ lArray[1];
        lArray2[2] = lArray2[2] ^ lArray[2];
        lArray2[3] = lArray2[3] ^ lArray[3];
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(193, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] lArray = Nat256.createExt64();
        Nat256.copy64(x, z);
        for (int i2 = 1; i2 < 193; i2 += 2) {
            SecT193Field.implSquare(z, lArray);
            SecT193Field.reduce(lArray, z);
            SecT193Field.implSquare(z, lArray);
            SecT193Field.reduce(lArray, z);
            SecT193Field.a(x, z);
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat256.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat256.create64();
        long[] lArray2 = Nat256.create64();
        SecT193Field.square(x, lArray);
        SecT193Field.squareN(lArray, 1, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray2, 1, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 3, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 6, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 12, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 24, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 48, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 96, lArray2);
        SecT193Field.multiply(lArray, lArray2, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implMultiply(x, y, lArray);
        SecT193Field.reduce(lArray, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implMultiply(x, y, lArray);
        SecT193Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        long l7 = xx[5];
        long l8 = xx[6];
        l4 ^= l8 << 63;
        l5 ^= l8 >>> 1 ^ l8 << 14;
        l3 ^= l7 << 63;
        l4 ^= l7 >>> 1 ^ l7 << 14;
        long l9 = (l5 ^= l7 >>> 50) >>> 1;
        z[0] = (l2 ^= (l6 ^= l8 >>> 50) << 63) ^ l9 ^ l9 << 15;
        z[1] = (l3 ^= l6 >>> 1 ^ l6 << 14) ^ l9 >>> 49;
        z[2] = l4 ^= l6 >>> 50;
        z[3] = l5 & 1L;
    }

    public static void reduce63(long[] z, int zOff) {
        long l2 = z[zOff + 3];
        long l3 = l2 >>> 1;
        int n2 = zOff;
        z[n2] = z[n2] ^ (l3 ^ l3 << 15);
        int n3 = zOff + 1;
        z[n3] = z[n3] ^ l3 >>> 49;
        z[zOff + 3] = l2 & 1L;
    }

    public static void sqrt(long[] x, long[] z) {
        long l2 = Interleave.unshuffle(x[0]);
        long l3 = Interleave.unshuffle(x[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[2]);
        long l6 = l2 & 0xFFFFFFFFL ^ x[3] << 32;
        long l7 = l2 >>> 32;
        z[0] = l4 ^ l5 << 8;
        z[1] = l6 ^ l7 << 8 ^ l5 >>> 56 ^ l5 << 33;
        z[2] = l7 >>> 56 ^ l7 << 33 ^ l5 >>> 31;
        z[3] = l7 >>> 31;
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implSquare(x, lArray);
        SecT193Field.reduce(lArray, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implSquare(x, lArray);
        SecT193Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x, int n2, long[] z) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implSquare(x, lArray);
        SecT193Field.reduce(lArray, z);
        while (--n2 > 0) {
            SecT193Field.implSquare(z, lArray);
            SecT193Field.reduce(lArray, z);
        }
    }

    public static int trace(long[] x) {
        return (int)x[0] & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        long l8 = zz[6];
        long l9 = zz[7];
        zz[0] = l2 ^ l3 << 49;
        zz[1] = l3 >>> 15 ^ l4 << 34;
        zz[2] = l4 >>> 30 ^ l5 << 19;
        zz[3] = l5 >>> 45 ^ l6 << 4 ^ l7 << 53;
        zz[4] = l6 >>> 60 ^ l8 << 38 ^ l7 >>> 11;
        zz[5] = l8 >>> 26 ^ l9 << 23;
        zz[6] = l9 >>> 41;
        zz[7] = 0L;
    }

    protected static void implExpand(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = x[2];
        long l5 = x[3];
        z[0] = l2 & 0x1FFFFFFFFFFFFL;
        z[1] = (l2 >>> 49 ^ l3 << 15) & 0x1FFFFFFFFFFFFL;
        z[2] = (l3 >>> 34 ^ l4 << 30) & 0x1FFFFFFFFFFFFL;
        z[3] = l4 >>> 19 ^ l5 << 45;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        int n2;
        long[] lArray = new long[4];
        long[] lArray2 = new long[4];
        SecT193Field.implExpand(x, lArray);
        SecT193Field.implExpand(y, lArray2);
        long[] lArray3 = new long[8];
        SecT193Field.implMulwAcc(lArray3, lArray[0], lArray2[0], zz, 0);
        SecT193Field.implMulwAcc(lArray3, lArray[1], lArray2[1], zz, 1);
        SecT193Field.implMulwAcc(lArray3, lArray[2], lArray2[2], zz, 2);
        SecT193Field.implMulwAcc(lArray3, lArray[3], lArray2[3], zz, 3);
        for (n2 = 5; n2 > 0; --n2) {
            int n3 = n2;
            zz[n3] = zz[n3] ^ zz[n2 - 1];
        }
        SecT193Field.implMulwAcc(lArray3, lArray[0] ^ lArray[1], lArray2[0] ^ lArray2[1], zz, 1);
        SecT193Field.implMulwAcc(lArray3, lArray[2] ^ lArray[3], lArray2[2] ^ lArray2[3], zz, 3);
        for (n2 = 7; n2 > 1; --n2) {
            int n4 = n2;
            zz[n4] = zz[n4] ^ zz[n2 - 2];
        }
        long l2 = lArray[0] ^ lArray[2];
        long l3 = lArray[1] ^ lArray[3];
        long l4 = lArray2[0] ^ lArray2[2];
        long l5 = lArray2[1] ^ lArray2[3];
        SecT193Field.implMulwAcc(lArray3, l2 ^ l3, l4 ^ l5, zz, 3);
        long[] lArray4 = new long[3];
        SecT193Field.implMulwAcc(lArray3, l2, l4, lArray4, 0);
        SecT193Field.implMulwAcc(lArray3, l3, l5, lArray4, 1);
        long l6 = lArray4[0];
        long l7 = lArray4[1];
        long l8 = lArray4[2];
        zz[2] = zz[2] ^ l6;
        zz[3] = zz[3] ^ (l6 ^ l7);
        zz[4] = zz[4] ^ (l8 ^ l7);
        zz[5] = zz[5] ^ l8;
        SecT193Field.implCompactExt(zz);
    }

    protected static void implMulwAcc(long[] u2, long x, long y, long[] z, int zOff) {
        u2[1] = y;
        u2[2] = u2[1] << 1;
        u2[3] = u2[2] ^ y;
        u2[4] = u2[2] << 1;
        u2[5] = u2[4] ^ y;
        u2[6] = u2[3] << 1;
        u2[7] = u2[6] ^ y;
        int n2 = (int)x;
        long l2 = 0L;
        long l3 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3;
        int n3 = 36;
        do {
            n2 = (int)(x >>> n3);
            long l4 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3 ^ u2[n2 >>> 6 & 7] << 6 ^ u2[n2 >>> 9 & 7] << 9 ^ u2[n2 >>> 12 & 7] << 12;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 15) > 0);
        int n4 = zOff;
        z[n4] = z[n4] ^ l3 & 0x1FFFFFFFFFFFFL;
        int n5 = zOff + 1;
        z[n5] = z[n5] ^ (l3 >>> 49 ^ l2 << 15);
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 3, zz, 0);
        zz[6] = x[3] & 1L;
    }
}

