/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat448;
import java.math.BigInteger;

public class SecT409Field {
    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
        z[3] = x[3] ^ y[3];
        z[4] = x[4] ^ y[4];
        z[5] = x[5] ^ y[5];
        z[6] = x[6] ^ y[6];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        for (int i2 = 0; i2 < 13; ++i2) {
            zz[i2] = xx[i2] ^ yy[i2];
        }
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
        z[5] = x[5];
        z[6] = x[6];
    }

    private static void a(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray2[0] ^ lArray[0];
        lArray2[1] = lArray2[1] ^ lArray[1];
        lArray2[2] = lArray2[2] ^ lArray[2];
        lArray2[3] = lArray2[3] ^ lArray[3];
        lArray2[4] = lArray2[4] ^ lArray[4];
        lArray2[5] = lArray2[5] ^ lArray[5];
        lArray2[6] = lArray2[6] ^ lArray[6];
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(409, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] lArray = Nat.create64(13);
        Nat448.copy64(x, z);
        for (int i2 = 1; i2 < 409; i2 += 2) {
            SecT409Field.implSquare(z, lArray);
            SecT409Field.reduce(lArray, z);
            SecT409Field.implSquare(z, lArray);
            SecT409Field.reduce(lArray, z);
            SecT409Field.a(x, z);
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat448.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat448.create64();
        long[] lArray2 = Nat448.create64();
        long[] lArray3 = Nat448.create64();
        SecT409Field.square(x, lArray);
        SecT409Field.squareN(lArray, 1, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray2, 1, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 3, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 6, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 12, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray3);
        SecT409Field.squareN(lArray3, 24, lArray);
        SecT409Field.squareN(lArray, 24, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 48, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 96, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 192, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.multiply(lArray, lArray3, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] lArray = Nat448.createExt64();
        SecT409Field.implMultiply(x, y, lArray);
        SecT409Field.reduce(lArray, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] lArray = Nat448.createExt64();
        SecT409Field.implMultiply(x, y, lArray);
        SecT409Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        long l7 = xx[5];
        long l8 = xx[6];
        long l9 = xx[7];
        long l10 = xx[12];
        l7 ^= l10 << 39;
        l8 ^= l10 >>> 25 ^ l10 << 62;
        l9 ^= l10 >>> 2;
        l10 = xx[11];
        l6 ^= l10 << 39;
        l7 ^= l10 >>> 25 ^ l10 << 62;
        l8 ^= l10 >>> 2;
        l10 = xx[10];
        l5 ^= l10 << 39;
        l6 ^= l10 >>> 25 ^ l10 << 62;
        l7 ^= l10 >>> 2;
        l10 = xx[9];
        l4 ^= l10 << 39;
        l5 ^= l10 >>> 25 ^ l10 << 62;
        l6 ^= l10 >>> 2;
        l10 = xx[8];
        l3 ^= l10 << 39;
        l4 ^= l10 >>> 25 ^ l10 << 62;
        l5 ^= l10 >>> 2;
        l10 = l9;
        long l11 = l8 >>> 25;
        z[0] = (l2 ^= l10 << 39) ^ l11;
        z[1] = (l3 ^= l10 >>> 25 ^ l10 << 62) ^ l11 << 23;
        z[2] = l4 ^= l10 >>> 2;
        z[3] = l5;
        z[4] = l6;
        z[5] = l7;
        z[6] = l8 & 0x1FFFFFFL;
    }

    public static void reduce39(long[] z, int zOff) {
        long l2 = z[zOff + 6];
        long l3 = l2 >>> 25;
        int n2 = zOff;
        z[n2] = z[n2] ^ l3;
        int n3 = zOff + 1;
        z[n3] = z[n3] ^ l3 << 23;
        z[zOff + 6] = l2 & 0x1FFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long l2 = Interleave.unshuffle(x[0]);
        long l3 = Interleave.unshuffle(x[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[2]);
        l3 = Interleave.unshuffle(x[3]);
        long l6 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l7 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[4]);
        l3 = Interleave.unshuffle(x[5]);
        long l8 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l9 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[6]);
        long l10 = l2 & 0xFFFFFFFFL;
        long l11 = l2 >>> 32;
        z[0] = l4 ^ l5 << 44;
        z[1] = l6 ^ l7 << 44 ^ l5 >>> 20;
        z[2] = l8 ^ l9 << 44 ^ l7 >>> 20;
        z[3] = l10 ^ l11 << 44 ^ l9 >>> 20 ^ l5 << 13;
        z[4] = l11 >>> 20 ^ l7 << 13 ^ l5 >>> 51;
        z[5] = l9 << 13 ^ l7 >>> 51;
        z[6] = l11 << 13 ^ l9 >>> 51;
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = Nat.create64(13);
        SecT409Field.implSquare(x, lArray);
        SecT409Field.reduce(lArray, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] lArray = Nat.create64(13);
        SecT409Field.implSquare(x, lArray);
        SecT409Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x, int n2, long[] z) {
        long[] lArray = Nat.create64(13);
        SecT409Field.implSquare(x, lArray);
        SecT409Field.reduce(lArray, z);
        while (--n2 > 0) {
            SecT409Field.implSquare(z, lArray);
            SecT409Field.reduce(lArray, z);
        }
    }

    public static int trace(long[] x) {
        return (int)x[0] & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        long l8 = zz[6];
        long l9 = zz[7];
        long l10 = zz[8];
        long l11 = zz[9];
        long l12 = zz[10];
        long l13 = zz[11];
        long l14 = zz[12];
        long l15 = zz[13];
        zz[0] = l2 ^ l3 << 59;
        zz[1] = l3 >>> 5 ^ l4 << 54;
        zz[2] = l4 >>> 10 ^ l5 << 49;
        zz[3] = l5 >>> 15 ^ l6 << 44;
        zz[4] = l6 >>> 20 ^ l7 << 39;
        zz[5] = l7 >>> 25 ^ l8 << 34;
        zz[6] = l8 >>> 30 ^ l9 << 29;
        zz[7] = l9 >>> 35 ^ l10 << 24;
        zz[8] = l10 >>> 40 ^ l11 << 19;
        zz[9] = l11 >>> 45 ^ l12 << 14;
        zz[10] = l12 >>> 50 ^ l13 << 9;
        zz[11] = l13 >>> 55 ^ l14 << 4 ^ l15 << 63;
        zz[12] = l15 >>> 1;
    }

    protected static void implExpand(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = x[2];
        long l5 = x[3];
        long l6 = x[4];
        long l7 = x[5];
        long l8 = x[6];
        z[0] = l2 & 0x7FFFFFFFFFFFFFFL;
        z[1] = (l2 >>> 59 ^ l3 << 5) & 0x7FFFFFFFFFFFFFFL;
        z[2] = (l3 >>> 54 ^ l4 << 10) & 0x7FFFFFFFFFFFFFFL;
        z[3] = (l4 >>> 49 ^ l5 << 15) & 0x7FFFFFFFFFFFFFFL;
        z[4] = (l5 >>> 44 ^ l6 << 20) & 0x7FFFFFFFFFFFFFFL;
        z[5] = (l6 >>> 39 ^ l7 << 25) & 0x7FFFFFFFFFFFFFFL;
        z[6] = l7 >>> 34 ^ l8 << 30;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long[] lArray = new long[7];
        long[] lArray2 = new long[7];
        SecT409Field.implExpand(x, lArray);
        SecT409Field.implExpand(y, lArray2);
        long[] lArray3 = new long[8];
        for (int i2 = 0; i2 < 7; ++i2) {
            SecT409Field.implMulwAcc(lArray3, lArray[i2], lArray2[i2], zz, i2 << 1);
        }
        long l2 = zz[0];
        long l3 = zz[1];
        zz[1] = (l2 ^= zz[2]) ^ l3;
        zz[2] = (l2 ^= zz[4]) ^ (l3 ^= zz[3]);
        zz[3] = (l2 ^= zz[6]) ^ (l3 ^= zz[5]);
        zz[4] = (l2 ^= zz[8]) ^ (l3 ^= zz[7]);
        zz[5] = (l2 ^= zz[10]) ^ (l3 ^= zz[9]);
        zz[6] = (l2 ^= zz[12]) ^ (l3 ^= zz[11]);
        long l4 = l2 ^ (l3 ^= zz[13]);
        zz[7] = zz[0] ^ l4;
        zz[8] = zz[1] ^ l4;
        zz[9] = zz[2] ^ l4;
        zz[10] = zz[3] ^ l4;
        zz[11] = zz[4] ^ l4;
        zz[12] = zz[5] ^ l4;
        zz[13] = zz[6] ^ l4;
        SecT409Field.implMulwAcc(lArray3, lArray[0] ^ lArray[1], lArray2[0] ^ lArray2[1], zz, 1);
        SecT409Field.implMulwAcc(lArray3, lArray[0] ^ lArray[2], lArray2[0] ^ lArray2[2], zz, 2);
        SecT409Field.implMulwAcc(lArray3, lArray[0] ^ lArray[3], lArray2[0] ^ lArray2[3], zz, 3);
        SecT409Field.implMulwAcc(lArray3, lArray[1] ^ lArray[2], lArray2[1] ^ lArray2[2], zz, 3);
        SecT409Field.implMulwAcc(lArray3, lArray[0] ^ lArray[4], lArray2[0] ^ lArray2[4], zz, 4);
        SecT409Field.implMulwAcc(lArray3, lArray[1] ^ lArray[3], lArray2[1] ^ lArray2[3], zz, 4);
        SecT409Field.implMulwAcc(lArray3, lArray[0] ^ lArray[5], lArray2[0] ^ lArray2[5], zz, 5);
        SecT409Field.implMulwAcc(lArray3, lArray[1] ^ lArray[4], lArray2[1] ^ lArray2[4], zz, 5);
        SecT409Field.implMulwAcc(lArray3, lArray[2] ^ lArray[3], lArray2[2] ^ lArray2[3], zz, 5);
        SecT409Field.implMulwAcc(lArray3, lArray[0] ^ lArray[6], lArray2[0] ^ lArray2[6], zz, 6);
        SecT409Field.implMulwAcc(lArray3, lArray[1] ^ lArray[5], lArray2[1] ^ lArray2[5], zz, 6);
        SecT409Field.implMulwAcc(lArray3, lArray[2] ^ lArray[4], lArray2[2] ^ lArray2[4], zz, 6);
        SecT409Field.implMulwAcc(lArray3, lArray[1] ^ lArray[6], lArray2[1] ^ lArray2[6], zz, 7);
        SecT409Field.implMulwAcc(lArray3, lArray[2] ^ lArray[5], lArray2[2] ^ lArray2[5], zz, 7);
        SecT409Field.implMulwAcc(lArray3, lArray[3] ^ lArray[4], lArray2[3] ^ lArray2[4], zz, 7);
        SecT409Field.implMulwAcc(lArray3, lArray[2] ^ lArray[6], lArray2[2] ^ lArray2[6], zz, 8);
        SecT409Field.implMulwAcc(lArray3, lArray[3] ^ lArray[5], lArray2[3] ^ lArray2[5], zz, 8);
        SecT409Field.implMulwAcc(lArray3, lArray[3] ^ lArray[6], lArray2[3] ^ lArray2[6], zz, 9);
        SecT409Field.implMulwAcc(lArray3, lArray[4] ^ lArray[5], lArray2[4] ^ lArray2[5], zz, 9);
        SecT409Field.implMulwAcc(lArray3, lArray[4] ^ lArray[6], lArray2[4] ^ lArray2[6], zz, 10);
        SecT409Field.implMulwAcc(lArray3, lArray[5] ^ lArray[6], lArray2[5] ^ lArray2[6], zz, 11);
        SecT409Field.implCompactExt(zz);
    }

    protected static void implMulwAcc(long[] u2, long x, long y, long[] z, int zOff) {
        u2[1] = y;
        u2[2] = u2[1] << 1;
        u2[3] = u2[2] ^ y;
        u2[4] = u2[2] << 1;
        u2[5] = u2[4] ^ y;
        u2[6] = u2[3] << 1;
        u2[7] = u2[6] ^ y;
        int n2 = (int)x;
        long l2 = 0L;
        long l3 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3;
        int n3 = 54;
        do {
            n2 = (int)(x >>> n3);
            long l4 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 6) > 0);
        int n4 = zOff;
        z[n4] = z[n4] ^ l3 & 0x7FFFFFFFFFFFFFFL;
        int n5 = zOff + 1;
        z[n5] = z[n5] ^ (l3 >>> 59 ^ l2 << 5);
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 6, zz, 0);
        zz[12] = Interleave.expand32to64((int)x[6]);
    }
}

