/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WTauNafMultiplier;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT409FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT409K1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat448;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT409K1Curve
extends ECCurve.AbstractF2m {
    private static final ECFieldElement[] c = new ECFieldElement[]{new SecT409FieldElement(ECConstants.ONE)};
    protected SecT409K1Point infinity = new SecT409K1Point(this, null, null);

    public SecT409K1Curve() {
        super(409, 87, 0, 0);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decodeStrict("7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE5F83B2D4EA20400EC4557D5ED3E3E7CA5B4B5C83B8E01E5FCF"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT409K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT409FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecT409K1Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecT409K1Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 409;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 7;
        final long[] lArray = new long[len * 7 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 7);
            n3 += 7;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] lArray3 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    long l2 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 7; ++i3) {
                        int n3 = i3;
                        lArray3[n3] = lArray3[n3] ^ lArray[n2 + i3] & l2;
                        int n4 = i3;
                        lArray2[n4] = lArray2[n4] ^ lArray[n2 + 7 + i3] & l2;
                    }
                    n2 += 14;
                }
                return this.a(lArray3, lArray2);
            }

            @Override
            public ECPoint lookupVar(int index) {
                long[] lArray3 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n2 = index * 7 * 2;
                for (int i2 = 0; i2 < 7; ++i2) {
                    lArray3[i2] = lArray[n2 + i2];
                    lArray2[i2] = lArray[n2 + 7 + i2];
                }
                return this.a(lArray3, lArray2);
            }

            private ECPoint a(long[] lArray3, long[] lArray2) {
                return SecT409K1Curve.this.createRawPoint(new SecT409FieldElement(lArray3), new SecT409FieldElement(lArray2), c);
            }
        };
    }
}

