/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat576;
import java.math.BigInteger;

public class SecT571Field {
    private static final long[] a = new long[]{3161836309350906777L, -7642453882179322845L, -3821226941089661423L, 7312758566309945096L, -556661012383879292L, 8945041530681231562L, -4750851271514160027L, 6847946401097695794L, 541669439031730457L};

    public static void add(long[] x, long[] y, long[] z) {
        for (int i2 = 0; i2 < 9; ++i2) {
            z[i2] = x[i2] ^ y[i2];
        }
    }

    private static void a(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4) {
        for (int i2 = 0; i2 < 9; ++i2) {
            lArray3[n4 + i2] = lArray[n2 + i2] ^ lArray2[n3 + i2];
        }
    }

    public static void addBothTo(long[] x, long[] y, long[] z) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n2 = i2;
            z[n2] = z[n2] ^ (x[i2] ^ y[i2]);
        }
    }

    private static void b(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n5 = n4 + i2;
            lArray3[n5] = lArray3[n5] ^ (lArray[n2 + i2] ^ lArray2[n3 + i2]);
        }
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        for (int i2 = 0; i2 < 18; ++i2) {
            zz[i2] = xx[i2] ^ yy[i2];
        }
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        for (int i2 = 1; i2 < 9; ++i2) {
            z[i2] = x[i2];
        }
    }

    private static void a(long[] lArray, long[] lArray2) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n2 = i2;
            lArray2[n2] = lArray2[n2] ^ lArray[i2];
        }
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(571, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] lArray = Nat576.createExt64();
        Nat576.copy64(x, z);
        for (int i2 = 1; i2 < 571; i2 += 2) {
            SecT571Field.implSquare(z, lArray);
            SecT571Field.reduce(lArray, z);
            SecT571Field.implSquare(z, lArray);
            SecT571Field.reduce(lArray, z);
            SecT571Field.a(x, z);
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat576.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat576.create64();
        long[] lArray2 = Nat576.create64();
        long[] lArray3 = Nat576.create64();
        SecT571Field.square(x, lArray3);
        SecT571Field.square(lArray3, lArray);
        SecT571Field.square(lArray, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 2, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.multiply(lArray, lArray3, lArray);
        SecT571Field.squareN(lArray, 5, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray2, 5, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 15, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray3);
        SecT571Field.squareN(lArray3, 30, lArray);
        SecT571Field.squareN(lArray, 30, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 60, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray2, 60, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 180, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray2, 180, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.multiply(lArray, lArray3, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiply(x, y, lArray);
        SecT571Field.reduce(lArray, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiply(x, y, lArray);
        SecT571Field.addExt(zz, lArray, zz);
    }

    public static void multiplyPrecomp(long[] x, long[] precomp, long[] z) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(x, precomp, lArray);
        SecT571Field.reduce(lArray, z);
    }

    public static void multiplyPrecompAddToExt(long[] x, long[] precomp, long[] zz) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(x, precomp, lArray);
        SecT571Field.addExt(zz, lArray, zz);
    }

    public static long[] precompMultiplicand(long[] x) {
        int n2 = 144;
        long[] lArray = new long[n2 << 1];
        System.arraycopy(x, 0, lArray, 9, 9);
        int n3 = 0;
        for (int i2 = 7; i2 > 0; --i2) {
            Nat.shiftUpBit64(9, lArray, (n3 += 18) >>> 1, 0L, lArray, n3);
            SecT571Field.reduce5(lArray, n3);
            SecT571Field.a(lArray, 9, lArray, n3, lArray, n3 + 9);
        }
        Nat.shiftUpBits64(n2, lArray, 0, 4, 0L, lArray, n2);
        return lArray;
    }

    public static void reduce(long[] xx, long[] z) {
        long l2 = xx[9];
        long l3 = xx[17];
        long l4 = l2;
        l2 = l4 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
        l4 = xx[8] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        for (int i2 = 16; i2 >= 10; --i2) {
            l3 = xx[i2];
            z[i2 - 8] = l4 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
            l4 = xx[i2 - 9] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        }
        l3 = l2;
        z[1] = l4 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
        l4 = xx[0] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        long l5 = z[8];
        long l6 = l5 >>> 59;
        z[0] = l4 ^ l6 ^ l6 << 2 ^ l6 << 5 ^ l6 << 10;
        z[8] = l5 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void reduce5(long[] z, int zOff) {
        long l2 = z[zOff + 8];
        long l3 = l2 >>> 59;
        int n2 = zOff;
        z[n2] = z[n2] ^ (l3 ^ l3 << 2 ^ l3 << 5 ^ l3 << 10);
        z[zOff + 8] = l2 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long[] lArray = Nat576.create64();
        long[] lArray2 = Nat576.create64();
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            long l2 = Interleave.unshuffle(x[n2++]);
            long l3 = Interleave.unshuffle(x[n2++]);
            lArray[i2] = l2 & 0xFFFFFFFFL | l3 << 32;
            lArray2[i2] = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        }
        long l4 = Interleave.unshuffle(x[n2]);
        lArray[4] = l4 & 0xFFFFFFFFL;
        lArray2[4] = l4 >>> 32;
        SecT571Field.multiply(lArray2, a, z);
        SecT571Field.add(z, lArray, z);
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implSquare(x, lArray);
        SecT571Field.reduce(lArray, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implSquare(x, lArray);
        SecT571Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x, int n2, long[] z) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implSquare(x, lArray);
        SecT571Field.reduce(lArray, z);
        while (--n2 > 0) {
            SecT571Field.implSquare(z, lArray);
            SecT571Field.reduce(lArray, z);
        }
    }

    public static int trace(long[] x) {
        return (int)(x[0] ^ x[8] >>> 49 ^ x[8] >>> 57) & 1;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long[] lArray = new long[16];
        for (int i2 = 0; i2 < 9; ++i2) {
            SecT571Field.implMulwAcc(lArray, x[i2], y[i2], zz, i2 << 1);
        }
        long l2 = zz[0];
        long l3 = zz[1];
        zz[1] = (l2 ^= zz[2]) ^ l3;
        zz[2] = (l2 ^= zz[4]) ^ (l3 ^= zz[3]);
        zz[3] = (l2 ^= zz[6]) ^ (l3 ^= zz[5]);
        zz[4] = (l2 ^= zz[8]) ^ (l3 ^= zz[7]);
        zz[5] = (l2 ^= zz[10]) ^ (l3 ^= zz[9]);
        zz[6] = (l2 ^= zz[12]) ^ (l3 ^= zz[11]);
        zz[7] = (l2 ^= zz[14]) ^ (l3 ^= zz[13]);
        zz[8] = (l2 ^= zz[16]) ^ (l3 ^= zz[15]);
        long l4 = l2 ^ (l3 ^= zz[17]);
        zz[9] = zz[0] ^ l4;
        zz[10] = zz[1] ^ l4;
        zz[11] = zz[2] ^ l4;
        zz[12] = zz[3] ^ l4;
        zz[13] = zz[4] ^ l4;
        zz[14] = zz[5] ^ l4;
        zz[15] = zz[6] ^ l4;
        zz[16] = zz[7] ^ l4;
        zz[17] = zz[8] ^ l4;
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[1], y[0] ^ y[1], zz, 1);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[2], y[0] ^ y[2], zz, 2);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[3], y[0] ^ y[3], zz, 3);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[2], y[1] ^ y[2], zz, 3);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[4], y[0] ^ y[4], zz, 4);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[3], y[1] ^ y[3], zz, 4);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[5], y[0] ^ y[5], zz, 5);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[4], y[1] ^ y[4], zz, 5);
        SecT571Field.implMulwAcc(lArray, x[2] ^ x[3], y[2] ^ y[3], zz, 5);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[6], y[0] ^ y[6], zz, 6);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[5], y[1] ^ y[5], zz, 6);
        SecT571Field.implMulwAcc(lArray, x[2] ^ x[4], y[2] ^ y[4], zz, 6);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[7], y[0] ^ y[7], zz, 7);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[6], y[1] ^ y[6], zz, 7);
        SecT571Field.implMulwAcc(lArray, x[2] ^ x[5], y[2] ^ y[5], zz, 7);
        SecT571Field.implMulwAcc(lArray, x[3] ^ x[4], y[3] ^ y[4], zz, 7);
        SecT571Field.implMulwAcc(lArray, x[0] ^ x[8], y[0] ^ y[8], zz, 8);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[7], y[1] ^ y[7], zz, 8);
        SecT571Field.implMulwAcc(lArray, x[2] ^ x[6], y[2] ^ y[6], zz, 8);
        SecT571Field.implMulwAcc(lArray, x[3] ^ x[5], y[3] ^ y[5], zz, 8);
        SecT571Field.implMulwAcc(lArray, x[1] ^ x[8], y[1] ^ y[8], zz, 9);
        SecT571Field.implMulwAcc(lArray, x[2] ^ x[7], y[2] ^ y[7], zz, 9);
        SecT571Field.implMulwAcc(lArray, x[3] ^ x[6], y[3] ^ y[6], zz, 9);
        SecT571Field.implMulwAcc(lArray, x[4] ^ x[5], y[4] ^ y[5], zz, 9);
        SecT571Field.implMulwAcc(lArray, x[2] ^ x[8], y[2] ^ y[8], zz, 10);
        SecT571Field.implMulwAcc(lArray, x[3] ^ x[7], y[3] ^ y[7], zz, 10);
        SecT571Field.implMulwAcc(lArray, x[4] ^ x[6], y[4] ^ y[6], zz, 10);
        SecT571Field.implMulwAcc(lArray, x[3] ^ x[8], y[3] ^ y[8], zz, 11);
        SecT571Field.implMulwAcc(lArray, x[4] ^ x[7], y[4] ^ y[7], zz, 11);
        SecT571Field.implMulwAcc(lArray, x[5] ^ x[6], y[5] ^ y[6], zz, 11);
        SecT571Field.implMulwAcc(lArray, x[4] ^ x[8], y[4] ^ y[8], zz, 12);
        SecT571Field.implMulwAcc(lArray, x[5] ^ x[7], y[5] ^ y[7], zz, 12);
        SecT571Field.implMulwAcc(lArray, x[5] ^ x[8], y[5] ^ y[8], zz, 13);
        SecT571Field.implMulwAcc(lArray, x[6] ^ x[7], y[6] ^ y[7], zz, 13);
        SecT571Field.implMulwAcc(lArray, x[6] ^ x[8], y[6] ^ y[8], zz, 14);
        SecT571Field.implMulwAcc(lArray, x[7] ^ x[8], y[7] ^ y[8], zz, 15);
    }

    protected static void implMultiplyPrecomp(long[] x, long[] precomp, long[] zz) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 15;
        for (n6 = 56; n6 >= 0; n6 -= 8) {
            for (n5 = 1; n5 < 9; n5 += 2) {
                n4 = (int)(x[n5] >>> n6);
                n3 = n4 & n7;
                n2 = n4 >>> 4 & n7;
                SecT571Field.b(precomp, 9 * n3, precomp, 9 * (n2 + 16), zz, n5 - 1);
            }
            Nat.shiftUpBits64(16, zz, 0, 8, 0L);
        }
        for (n6 = 56; n6 >= 0; n6 -= 8) {
            for (n5 = 0; n5 < 9; n5 += 2) {
                n4 = (int)(x[n5] >>> n6);
                n3 = n4 & n7;
                n2 = n4 >>> 4 & n7;
                SecT571Field.b(precomp, 9 * n3, precomp, 9 * (n2 + 16), zz, n5);
            }
            if (n6 <= 0) continue;
            Nat.shiftUpBits64(18, zz, 0, 8, 0L);
        }
    }

    protected static void implMulwAcc(long[] u2, long x, long y, long[] z, int zOff) {
        int n2;
        u2[1] = y;
        for (n2 = 2; n2 < 16; n2 += 2) {
            u2[n2] = u2[n2 >>> 1] << 1;
            u2[n2 + 1] = u2[n2] ^ y;
        }
        n2 = (int)x;
        long l2 = 0L;
        long l3 = u2[n2 & 0xF] ^ u2[n2 >>> 4 & 0xF] << 4;
        int n3 = 56;
        do {
            n2 = (int)(x >>> n3);
            long l4 = u2[n2 & 0xF] ^ u2[n2 >>> 4 & 0xF] << 4;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 8) > 0);
        for (int i2 = 0; i2 < 7; ++i2) {
            x = (x & 0xFEFEFEFEFEFEFEFEL) >>> 1;
            l2 ^= x & y << i2 >> 63;
        }
        int n4 = zOff;
        z[n4] = z[n4] ^ l3;
        int n5 = zOff + 1;
        z[n5] = z[n5] ^ l2;
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 9, zz, 0);
    }
}

