/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.endo;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPointMap;
import com.enterprisedt.bouncycastle.math.ec.ScaleXPointMap;
import com.enterprisedt.bouncycastle.math.ec.endo.EndoUtil;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVTypeBParameters;
import java.math.BigInteger;

public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve curve, GLVTypeBParameters parameters) {
        this.parameters = parameters;
        this.pointMap = new ScaleXPointMap(curve.fromBigInteger(parameters.getBeta()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger k2) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), k2);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

