/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.rfc7748;

import com.enterprisedt.bouncycastle.math.ec.rfc7748.X25519Field;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class X25519 {
    public static final int POINT_SIZE = 32;
    public static final int SCALAR_SIZE = 32;

    public static boolean calculateAgreement(byte[] k2, int kOff, byte[] u2, int uOff, byte[] r2, int rOff) {
        X25519.scalarMult(k2, kOff, u2, uOff, r2, rOff);
        return !Arrays.areAllZeroes(r2, rOff, 32);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        return n3 |= byArray[++n2] << 24;
    }

    private static void a(byte[] byArray, int n2, int[] nArray) {
        for (int i2 = 0; i2 < 8; ++i2) {
            nArray[i2] = X25519.a(byArray, n2 + i2 * 4);
        }
        nArray[0] = nArray[0] & 0xFFFFFFF8;
        nArray[7] = nArray[7] & Integer.MAX_VALUE;
        nArray[7] = nArray[7] | 0x40000000;
    }

    public static void generatePrivateKey(SecureRandom random, byte[] k2) {
        if (k2.length != 32) {
            throw new IllegalArgumentException("k");
        }
        random.nextBytes(k2);
        k2[0] = (byte)(k2[0] & 0xF8);
        k2[31] = (byte)(k2[31] & 0x7F);
        k2[31] = (byte)(k2[31] | 0x40);
    }

    public static void generatePublicKey(byte[] k2, int kOff, byte[] r2, int rOff) {
        X25519.scalarMultBase(k2, kOff, r2, rOff);
    }

    private static void a(int[] nArray, int[] nArray2) {
        int[] nArray3 = a.create();
        int[] nArray4 = a.create();
        a.apm(nArray, nArray2, nArray3, nArray4);
        a.sqr(nArray3, nArray3);
        a.sqr(nArray4, nArray4);
        a.mul(nArray3, nArray4, nArray);
        a.sub(nArray3, nArray4, nArray3);
        a.mul(nArray3, 121666, nArray2);
        a.add(nArray2, nArray4, nArray2);
        a.mul(nArray2, nArray3, nArray2);
    }

    public static void precompute() {
        Ed25519.precompute();
    }

    public static void scalarMult(byte[] k2, int kOff, byte[] u2, int uOff, byte[] r2, int rOff) {
        int n2;
        int[] nArray = new int[8];
        X25519.a(k2, kOff, nArray);
        int[] nArray2 = a.create();
        a.decode(u2, uOff, nArray2);
        int[] nArray3 = a.create();
        a.copy(nArray2, 0, nArray3, 0);
        int[] nArray4 = a.create();
        nArray4[0] = 1;
        int[] nArray5 = a.create();
        nArray5[0] = 1;
        int[] nArray6 = a.create();
        int[] nArray7 = a.create();
        int[] nArray8 = a.create();
        int n3 = 254;
        int n4 = 1;
        do {
            a.apm(nArray5, nArray6, nArray7, nArray5);
            a.apm(nArray3, nArray4, nArray6, nArray3);
            a.mul(nArray7, nArray3, nArray7);
            a.mul(nArray5, nArray6, nArray5);
            a.sqr(nArray6, nArray6);
            a.sqr(nArray3, nArray3);
            a.sub(nArray6, nArray3, nArray8);
            a.mul(nArray8, 121666, nArray4);
            a.add(nArray4, nArray3, nArray4);
            a.mul(nArray4, nArray8, nArray4);
            a.mul(nArray3, nArray6, nArray3);
            a.apm(nArray7, nArray5, nArray5, nArray6);
            a.sqr(nArray5, nArray5);
            a.sqr(nArray6, nArray6);
            a.mul(nArray6, nArray2, nArray6);
            n2 = --n3 >>> 5;
            int n5 = n3 & 0x1F;
            int n6 = nArray[n2] >>> n5 & 1;
            a.cswap(n4 ^= n6, nArray3, nArray5);
            a.cswap(n4, nArray4, nArray6);
            n4 = n6;
        } while (n3 >= 3);
        for (n2 = 0; n2 < 3; ++n2) {
            X25519.a(nArray3, nArray4);
        }
        a.inv(nArray4, nArray4);
        a.mul(nArray3, nArray4, nArray3);
        a.normalize(nArray3);
        a.encode(nArray3, r2, rOff);
    }

    public static void scalarMultBase(byte[] k2, int kOff, byte[] r2, int rOff) {
        int[] nArray = a.create();
        int[] nArray2 = a.create();
        Ed25519.scalarMultBaseYZ(Friend.a, k2, kOff, nArray, nArray2);
        a.apm(nArray2, nArray, nArray, nArray2);
        a.inv(nArray2, nArray2);
        a.mul(nArray, nArray2, nArray);
        a.normalize(nArray);
        a.encode(nArray, r2, rOff);
    }

    private static class a
    extends X25519Field {
    }

    public static class Friend {
        private static final Friend a = new Friend();

        private Friend() {
        }
    }
}

