/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.tools;

import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class TraceOptimizer {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private static final SecureRandom b = new SecureRandom();

    public static void main(String[] args) {
        TreeSet treeSet = new TreeSet(TraceOptimizer.a(ECNamedCurveTable.getNames()));
        treeSet.addAll(TraceOptimizer.a(CustomNamedCurves.getNames()));
        for (String string : treeSet) {
            ECCurve eCCurve;
            X9ECParametersHolder x9ECParametersHolder = CustomNamedCurves.getByNameLazy(string);
            if (x9ECParametersHolder == null) {
                x9ECParametersHolder = ECNamedCurveTable.getByNameLazy(string);
            }
            if (x9ECParametersHolder == null || !ECAlgorithms.isF2mCurve(eCCurve = x9ECParametersHolder.getCurve())) continue;
            System.out.print(string + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(eCCurve);
        }
    }

    public static void printNonZeroTraceBits(ECCurve curve) {
        if (!ECAlgorithms.isF2mCurve(curve)) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(curve);
    }

    public static void implPrintNonZeroTraceBits(ECCurve curve) {
        int n2;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger;
        int n3;
        int n4 = curve.getFieldSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            if (0 == (n3 & 1) && 0 != n3) {
                if (!arrayList.contains(Integers.valueOf(n3 >>> 1))) continue;
                arrayList.add(Integers.valueOf(n3));
                System.out.print(" " + n3);
                continue;
            }
            bigInteger = a.shiftLeft(n3);
            eCFieldElement = curve.fromBigInteger(bigInteger);
            n2 = TraceOptimizer.a(eCFieldElement);
            if (n2 == 0) continue;
            arrayList.add(Integers.valueOf(n3));
            System.out.print(" " + n3);
        }
        System.out.println();
        for (n3 = 0; n3 < 1000; ++n3) {
            bigInteger = new BigInteger(n4, b);
            eCFieldElement = curve.fromBigInteger(bigInteger);
            n2 = TraceOptimizer.a(eCFieldElement);
            int n5 = 0;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n6 = (Integer)arrayList.get(i2);
                if (!bigInteger.testBit(n6)) continue;
                n5 ^= 1;
            }
            if (n2 == n5) continue;
            throw new IllegalStateException("Optimized-trace sanity check failed");
        }
    }

    private static int a(ECFieldElement eCFieldElement) {
        int n2 = eCFieldElement.getFieldSize();
        int n3 = 31 - Integers.numberOfLeadingZeros(n2);
        int n4 = 1;
        ECFieldElement eCFieldElement2 = eCFieldElement;
        while (n3 > 0) {
            eCFieldElement2 = eCFieldElement2.squarePow(n4).add(eCFieldElement2);
            if (0 == ((n4 = n2 >>> --n3) & 1)) continue;
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        if (eCFieldElement2.isZero()) {
            return 0;
        }
        if (eCFieldElement2.isOne()) {
            return 1;
        }
        throw new IllegalStateException("Internal error in trace calculation");
    }

    private static ArrayList a(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }
}

