/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat192 {
    public static int add(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)y[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)y[5] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)y[4] & 0xFFFFFFFFL) + ((long)z[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)y[5] & 0xFFFFFFFFL) + ((long)z[5] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)z[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)z[5] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int xOff, int[] z, int zOff, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) + ((long)z[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 4] = (int)(l2 += ((long)x[xOff + 4] & 0xFFFFFFFFL) + ((long)z[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 5] = (int)(l2 += ((long)x[xOff + 5] & 0xFFFFFFFFL) + ((long)z[zOff + 5] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addToEachOther(int[] u2, int uOff, int[] v2, int vOff) {
        long l2 = 0L;
        u2[uOff + 0] = (int)(l2 += ((long)u2[uOff + 0] & 0xFFFFFFFFL) + ((long)v2[vOff + 0] & 0xFFFFFFFFL));
        v2[vOff + 0] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 1] = (int)(l2 += ((long)u2[uOff + 1] & 0xFFFFFFFFL) + ((long)v2[vOff + 1] & 0xFFFFFFFFL));
        v2[vOff + 1] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 2] = (int)(l2 += ((long)u2[uOff + 2] & 0xFFFFFFFFL) + ((long)v2[vOff + 2] & 0xFFFFFFFFL));
        v2[vOff + 2] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 3] = (int)(l2 += ((long)u2[uOff + 3] & 0xFFFFFFFFL) + ((long)v2[vOff + 3] & 0xFFFFFFFFL));
        v2[vOff + 3] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 4] = (int)(l2 += ((long)u2[uOff + 4] & 0xFFFFFFFFL) + ((long)v2[vOff + 4] & 0xFFFFFFFFL));
        v2[vOff + 4] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 5] = (int)(l2 += ((long)u2[uOff + 5] & 0xFFFFFFFFL) + ((long)v2[vOff + 5] & 0xFFFFFFFFL));
        v2[vOff + 5] = (int)l2;
        return (int)(l2 >>>= 32);
    }

    public static void copy(int[] x, int[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
        z[5] = x[5];
    }

    public static void copy(int[] x, int xOff, int[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
        z[zOff + 3] = x[xOff + 3];
        z[zOff + 4] = x[xOff + 4];
        z[zOff + 5] = x[xOff + 5];
    }

    public static void copy64(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
    }

    public static void copy64(long[] x, int xOff, long[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
    }

    public static int[] create() {
        return new int[6];
    }

    public static long[] create64() {
        return new long[3];
    }

    public static int[] createExt() {
        return new int[12];
    }

    public static long[] createExt64() {
        return new long[6];
    }

    public static boolean diff(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        boolean bl = Nat192.gte(x, xOff, y, yOff);
        if (bl) {
            Nat192.sub(x, xOff, y, yOff, z, zOff);
        } else {
            Nat192.sub(y, yOff, x, xOff, z, zOff);
        }
        return bl;
    }

    public static boolean eq(int[] x, int[] y) {
        for (int i2 = 5; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] x, long[] y) {
        for (int i2 = 2; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 192) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat192.create();
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = x.intValue();
            x = x.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 192) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat192.create64();
        for (int i2 = 0; i2 < 3; ++i2) {
            lArray[i2] = x.longValue();
            x = x.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] x, int bit) {
        if (bit == 0) {
            return x[0] & 1;
        }
        int n2 = bit >> 5;
        if (n2 < 0 || n2 >= 6) {
            return 0;
        }
        int n3 = bit & 0x1F;
        return x[n2] >>> n3 & 1;
    }

    public static boolean gte(int[] x, int[] y) {
        for (int i2 = 5; i2 >= 0; --i2) {
            int n2 = x[i2] ^ Integer.MIN_VALUE;
            int n3 = y[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] x, int xOff, int[] y, int yOff) {
        for (int i2 = 5; i2 >= 0; --i2) {
            int n2 = x[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x) {
        if (x[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < 6; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x) {
        for (int i2 = 0; i2 < 6; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x, int[] y, int[] zz) {
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        long l3 = (long)y[1] & 0xFFFFFFFFL;
        long l4 = (long)y[2] & 0xFFFFFFFFL;
        long l5 = (long)y[3] & 0xFFFFFFFFL;
        long l6 = (long)y[4] & 0xFFFFFFFFL;
        long l7 = (long)y[5] & 0xFFFFFFFFL;
        long l8 = 0L;
        long l9 = (long)x[0] & 0xFFFFFFFFL;
        zz[0] = (int)(l8 += l9 * l2);
        l8 >>>= 32;
        zz[1] = (int)(l8 += l9 * l3);
        l8 >>>= 32;
        zz[2] = (int)(l8 += l9 * l4);
        l8 >>>= 32;
        zz[3] = (int)(l8 += l9 * l5);
        l8 >>>= 32;
        zz[4] = (int)(l8 += l9 * l6);
        l8 >>>= 32;
        zz[5] = (int)(l8 += l9 * l7);
        zz[6] = (int)(l8 >>>= 32);
        for (int i2 = 1; i2 < 6; ++i2) {
            long l10 = 0L;
            long l11 = (long)x[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l10 += l11 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 1] = (int)(l10 += l11 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 2] = (int)(l10 += l11 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 3] = (int)(l10 += l11 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 4] = (int)(l10 += l11 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 5] = (int)(l10 += l11 * l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            zz[i2 + 6] = (int)(l10 >>>= 32);
        }
    }

    public static void mul(int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y[yOff + 4] & 0xFFFFFFFFL;
        long l7 = (long)y[yOff + 5] & 0xFFFFFFFFL;
        long l8 = 0L;
        long l9 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l8 += l9 * l2);
        l8 >>>= 32;
        zz[zzOff + 1] = (int)(l8 += l9 * l3);
        l8 >>>= 32;
        zz[zzOff + 2] = (int)(l8 += l9 * l4);
        l8 >>>= 32;
        zz[zzOff + 3] = (int)(l8 += l9 * l5);
        l8 >>>= 32;
        zz[zzOff + 4] = (int)(l8 += l9 * l6);
        l8 >>>= 32;
        zz[zzOff + 5] = (int)(l8 += l9 * l7);
        zz[zzOff + 6] = (int)(l8 >>>= 32);
        for (int i2 = 1; i2 < 6; ++i2) {
            long l10 = 0L;
            long l11 = (long)x[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l10 += l11 * l2 + ((long)zz[++zzOff + 0] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 1] = (int)(l10 += l11 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 2] = (int)(l10 += l11 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 3] = (int)(l10 += l11 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 4] = (int)(l10 += l11 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 5] = (int)(l10 += l11 * l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            zz[zzOff + 6] = (int)(l10 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x, int[] y, int[] zz) {
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        long l3 = (long)y[1] & 0xFFFFFFFFL;
        long l4 = (long)y[2] & 0xFFFFFFFFL;
        long l5 = (long)y[3] & 0xFFFFFFFFL;
        long l6 = (long)y[4] & 0xFFFFFFFFL;
        long l7 = (long)y[5] & 0xFFFFFFFFL;
        long l8 = 0L;
        for (int i2 = 0; i2 < 6; ++i2) {
            long l9 = 0L;
            long l10 = (long)x[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l9 += l10 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 1] = (int)(l9 += l10 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 2] = (int)(l9 += l10 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 3] = (int)(l9 += l10 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 4] = (int)(l9 += l10 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 5] = (int)(l9 += l10 * l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            zz[i2 + 6] = (int)(l8 += (l9 >>>= 32) + ((long)zz[i2 + 6] & 0xFFFFFFFFL));
            l8 >>>= 32;
        }
        return (int)l8;
    }

    public static int mulAddTo(int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y[yOff + 4] & 0xFFFFFFFFL;
        long l7 = (long)y[yOff + 5] & 0xFFFFFFFFL;
        long l8 = 0L;
        for (int i2 = 0; i2 < 6; ++i2) {
            long l9 = 0L;
            long l10 = (long)x[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l9 += l10 * l2 + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 1] = (int)(l9 += l10 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 2] = (int)(l9 += l10 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 3] = (int)(l9 += l10 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 4] = (int)(l9 += l10 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 5] = (int)(l9 += l10 * l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            zz[zzOff + 6] = (int)(l8 += (l9 >>>= 32) + ((long)zz[zzOff + 6] & 0xFFFFFFFFL));
            l8 >>>= 32;
            ++zzOff;
        }
        return (int)l8;
    }

    public static long mul33Add(int w, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)w & 0xFFFFFFFFL;
        long l4 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * l4 + ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = (long)x[xOff + 1] & 0xFFFFFFFFL;
        z[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l6 = (long)x[xOff + 2] & 0xFFFFFFFFL;
        z[zOff + 2] = (int)(l2 += l3 * l6 + l5 + ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l7 = (long)x[xOff + 3] & 0xFFFFFFFFL;
        z[zOff + 3] = (int)(l2 += l3 * l7 + l6 + ((long)y[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l8 = (long)x[xOff + 4] & 0xFFFFFFFFL;
        z[zOff + 4] = (int)(l2 += l3 * l8 + l7 + ((long)y[yOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l9 = (long)x[xOff + 5] & 0xFFFFFFFFL;
        z[zOff + 5] = (int)(l2 += l3 * l9 + l8 + ((long)y[yOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        return l2 += l9;
    }

    public static int mulWordAddExt(int x, int[] yy, int yyOff, int[] zz, int zzOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l2 += l3 * ((long)yy[yyOff + 0] & 0xFFFFFFFFL) + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 1] = (int)(l2 += l3 * ((long)yy[yyOff + 1] & 0xFFFFFFFFL) + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 2] = (int)(l2 += l3 * ((long)yy[yyOff + 2] & 0xFFFFFFFFL) + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 3] = (int)(l2 += l3 * ((long)yy[yyOff + 3] & 0xFFFFFFFFL) + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 4] = (int)(l2 += l3 * ((long)yy[yyOff + 4] & 0xFFFFFFFFL) + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 5] = (int)(l2 += l3 * ((long)yy[yyOff + 5] & 0xFFFFFFFFL) + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mul33DWordAdd(int x, long y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * l4 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = y >>> 32;
        z[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += l5 + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += (long)z[zOff + 3] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(6, z, zOff, 4);
    }

    public static int mul33WordAdd(int x, int y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = (long)y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l4 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(6, z, zOff, 3);
    }

    public static int mulWordDwordAdd(int x, long y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * (y & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l3 * (y >>> 32) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(6, z, zOff, 3);
    }

    public static int mulWord(int x, int[] y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[zOff + n2] = (int)(l2 += l3 * ((long)y[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < 6);
        return (int)l2;
    }

    public static void square(int[] x, int[] zz) {
        long l2;
        long l3;
        long l4 = (long)x[0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 5;
        int n4 = 12;
        do {
            l3 = (long)x[n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[--n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[--n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x[1] & 0xFFFFFFFFL;
        l3 = (long)zz[2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x[2] & 0xFFFFFFFFL;
        long l7 = (long)zz[3] & 0xFFFFFFFFL;
        long l8 = (long)zz[4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x[3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x[4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        long l15 = (long)x[5] & 0xFFFFFFFFL;
        long l16 = ((long)zz[9] & 0xFFFFFFFFL) + ((l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32) >>> 32);
        l14 &= 0xFFFFFFFFL;
        long l17 = ((long)zz[10] & 0xFFFFFFFFL) + (l16 >>> 32);
        l16 &= 0xFFFFFFFFL;
        n5 = (int)(l10 += l15 * l4);
        zz[5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l17 += (l16 += ((l14 += ((l13 += ((l11 += (l10 >>> 32) + l15 * l6) >>> 32) + l15 * l2) >>> 32) + l15 * l9) >>> 32) + l15 * l12) >>> 32;
        n5 = (int)l11;
        zz[6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l13;
        zz[7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l14;
        zz[8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l16;
        zz[9] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l17;
        zz[10] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[11] + (int)(l17 >>> 32);
        zz[11] = n5 << 1 | n2;
    }

    public static void square(int[] x, int xOff, int[] zz, int zzOff) {
        long l2;
        long l3;
        long l4 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 5;
        int n4 = 12;
        do {
            l3 = (long)x[xOff + n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[zzOff + --n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[zzOff + --n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[zzOff + 0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x[xOff + 1] & 0xFFFFFFFFL;
        l3 = (long)zz[zzOff + 2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[zzOff + 1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x[xOff + 2] & 0xFFFFFFFFL;
        long l7 = (long)zz[zzOff + 3] & 0xFFFFFFFFL;
        long l8 = (long)zz[zzOff + 4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[zzOff + 2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x[xOff + 3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[zzOff + 5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[zzOff + 6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[zzOff + 3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x[xOff + 4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[zzOff + 7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[zzOff + 8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[zzOff + 4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        long l15 = (long)x[xOff + 5] & 0xFFFFFFFFL;
        long l16 = ((long)zz[zzOff + 9] & 0xFFFFFFFFL) + ((l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32) >>> 32);
        l14 &= 0xFFFFFFFFL;
        long l17 = ((long)zz[zzOff + 10] & 0xFFFFFFFFL) + (l16 >>> 32);
        l16 &= 0xFFFFFFFFL;
        n5 = (int)(l10 += l15 * l4);
        zz[zzOff + 5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l17 += (l16 += ((l14 += ((l13 += ((l11 += (l10 >>> 32) + l15 * l6) >>> 32) + l15 * l2) >>> 32) + l15 * l9) >>> 32) + l15 * l12) >>> 32;
        n5 = (int)l11;
        zz[zzOff + 6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l13;
        zz[zzOff + 7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l14;
        zz[zzOff + 8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l16;
        zz[zzOff + 9] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l17;
        zz[zzOff + 10] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[zzOff + 11] + (int)(l17 >>> 32);
        zz[zzOff + 11] = n5 << 1 | n2;
    }

    public static int sub(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) - ((long)y[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) - ((long)y[5] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int sub(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) - ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) - ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) - ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) - ((long)y[yOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 4] = (int)(l2 += ((long)x[xOff + 4] & 0xFFFFFFFFL) - ((long)y[yOff + 4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 5] = (int)(l2 += ((long)x[xOff + 5] & 0xFFFFFFFFL) - ((long)y[yOff + 5] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subBothFrom(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[4] = (int)(l2 += ((long)z[4] & 0xFFFFFFFFL) - ((long)x[4] & 0xFFFFFFFFL) - ((long)y[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[5] = (int)(l2 += ((long)z[5] & 0xFFFFFFFFL) - ((long)x[5] & 0xFFFFFFFFL) - ((long)y[5] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[4] = (int)(l2 += ((long)z[4] & 0xFFFFFFFFL) - ((long)x[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[5] = (int)(l2 += ((long)z[5] & 0xFFFFFFFFL) - ((long)x[5] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x, int xOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)z[zOff + 0] & 0xFFFFFFFFL) - ((long)x[xOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) - ((long)x[xOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 2] = (int)(l2 += ((long)z[zOff + 2] & 0xFFFFFFFFL) - ((long)x[xOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 3] = (int)(l2 += ((long)z[zOff + 3] & 0xFFFFFFFFL) - ((long)x[xOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 4] = (int)(l2 += ((long)z[zOff + 4] & 0xFFFFFFFFL) - ((long)x[xOff + 4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 5] = (int)(l2 += ((long)z[zOff + 5] & 0xFFFFFFFFL) - ((long)x[xOff + 5] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static BigInteger toBigInteger(int[] x) {
        byte[] byArray = new byte[24];
        for (int i2 = 0; i2 < 6; ++i2) {
            int n2 = x[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, 5 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] x) {
        byte[] byArray = new byte[24];
        for (int i2 = 0; i2 < 3; ++i2) {
            long l2 = x[i2];
            if (l2 == 0L) continue;
            Pack.longToBigEndian(l2, byArray, 2 - i2 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] z) {
        z[0] = 0;
        z[1] = 0;
        z[2] = 0;
        z[3] = 0;
        z[4] = 0;
        z[5] = 0;
    }
}

