/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat576 {
    public static void copy64(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
        z[5] = x[5];
        z[6] = x[6];
        z[7] = x[7];
        z[8] = x[8];
    }

    public static void copy64(long[] x, int xOff, long[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
        z[zOff + 3] = x[xOff + 3];
        z[zOff + 4] = x[xOff + 4];
        z[zOff + 5] = x[xOff + 5];
        z[zOff + 6] = x[xOff + 6];
        z[zOff + 7] = x[xOff + 7];
        z[zOff + 8] = x[xOff + 8];
    }

    public static long[] create64() {
        return new long[9];
    }

    public static long[] createExt64() {
        return new long[18];
    }

    public static boolean eq64(long[] x, long[] y) {
        for (int i2 = 8; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static long[] fromBigInteger64(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 576) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat576.create64();
        for (int i2 = 0; i2 < 9; ++i2) {
            lArray[i2] = x.longValue();
            x = x.shiftRight(64);
        }
        return lArray;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        for (int i2 = 1; i2 < 9; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        for (int i2 = 0; i2 < 9; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static BigInteger toBigInteger64(long[] x) {
        byte[] byArray = new byte[72];
        for (int i2 = 0; i2 < 9; ++i2) {
            long l2 = x[i2];
            if (l2 == 0L) continue;
            Pack.longToBigEndian(l2, byArray, 8 - i2 << 3);
        }
        return new BigInteger(1, byArray);
    }
}

