/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class FalconPublicKey
extends ASN1Object {
    private byte[] a;

    public FalconPublicKey(byte[] h2) {
        this.a = h2;
    }

    public byte[] getH() {
        return this.a;
    }

    public FalconPublicKey(ASN1Sequence seq) {
        this.a = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        return new DERSequence(aSN1EncodableVector);
    }

    public static FalconPublicKey getInstance(Object o2) {
        if (o2 instanceof FalconPublicKey) {
            return (FalconPublicKey)o2;
        }
        if (o2 != null) {
            return new FalconPublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

