/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.asn1.SABERPublicKey;
import com.enterprisedt.bouncycastle.util.Arrays;

public class SABERPrivateKey
extends ASN1Object {
    private int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private SABERPublicKey e;

    public SABERPrivateKey(int version, byte[] z, byte[] s2, byte[] hpk) {
        this.a = version;
        if (version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = z;
        this.c = s2;
        this.d = hpk;
    }

    public SABERPrivateKey(int version, byte[] z, byte[] s2, byte[] hpk, SABERPublicKey publicKey) {
        this.a = version;
        if (version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = z;
        this.c = s2;
        this.d = hpk;
        this.e = publicKey;
    }

    private SABERPrivateKey(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.a != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        this.e = SABERPublicKey.getInstance(seq.getObjectAt(3));
        this.d = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4)).getOctets());
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getZ() {
        return this.b;
    }

    public byte[] getS() {
        return this.c;
    }

    public byte[] getHpk() {
        return this.d;
    }

    public SABERPublicKey getPublicKey() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        return new DERSequence(aSN1EncodableVector);
    }

    public static SABERPrivateKey getInstance(Object o2) {
        if (o2 instanceof SABERPrivateKey) {
            return (SABERPrivateKey)o2;
        }
        if (o2 != null) {
            return new SABERPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

