/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XMSSMTKeyParams
extends ASN1Object {
    private final ASN1Integer a;
    private final int b;
    private final int c;
    private final AlgorithmIdentifier d;

    public XMSSMTKeyParams(int height, int layers, AlgorithmIdentifier treeDigest) {
        this.a = new ASN1Integer(0L);
        this.b = height;
        this.c = layers;
        this.d = treeDigest;
    }

    private XMSSMTKeyParams(ASN1Sequence sequence) {
        this.a = ASN1Integer.getInstance(sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(sequence.getObjectAt(1)).intValueExact();
        this.c = ASN1Integer.getInstance(sequence.getObjectAt(2)).intValueExact();
        this.d = AlgorithmIdentifier.getInstance(sequence.getObjectAt(3));
    }

    public static XMSSMTKeyParams getInstance(Object o2) {
        if (o2 instanceof XMSSMTKeyParams) {
            return (XMSSMTKeyParams)o2;
        }
        if (o2 != null) {
            return new XMSSMTKeyParams(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public int getHeight() {
        return this.b;
    }

    public int getLayers() {
        return this.c;
    }

    public AlgorithmIdentifier getTreeDigest() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new ASN1Integer(this.c));
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

