/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSMTPrivateKey
extends ASN1Object {
    private final int a;
    private final long b;
    private final long c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;
    private final byte[] g;
    private final byte[] h;

    public XMSSMTPrivateKey(long index, byte[] secretKeySeed, byte[] secretKeyPRF, byte[] publicSeed, byte[] root, byte[] bdsState) {
        this.a = 0;
        this.b = index;
        this.d = Arrays.clone(secretKeySeed);
        this.e = Arrays.clone(secretKeyPRF);
        this.f = Arrays.clone(publicSeed);
        this.g = Arrays.clone(root);
        this.h = Arrays.clone(bdsState);
        this.c = -1L;
    }

    public XMSSMTPrivateKey(long index, byte[] secretKeySeed, byte[] secretKeyPRF, byte[] publicSeed, byte[] root, byte[] bdsState, long maxIndex) {
        this.a = 1;
        this.b = index;
        this.d = Arrays.clone(secretKeySeed);
        this.e = Arrays.clone(secretKeyPRF);
        this.f = Arrays.clone(publicSeed);
        this.g = Arrays.clone(root);
        this.h = Arrays.clone(bdsState);
        this.c = maxIndex;
    }

    private XMSSMTPrivateKey(ASN1Sequence seq) {
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(seq.getObjectAt(0));
        if (!aSN1Integer.hasValue(0) && !aSN1Integer.hasValue(1)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.a = aSN1Integer.intValueExact();
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(seq.getObjectAt(1));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).longValueExact();
        this.d = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
        this.e = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets());
        this.f = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets());
        this.g = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets());
        if (aSN1Sequence.size() == 6) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(5));
            if (aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("unknown tag in XMSSPrivateKey");
            }
            this.c = ASN1Integer.getInstance(aSN1TaggedObject, false).longValueExact();
        } else if (aSN1Sequence.size() == 5) {
            this.c = -1L;
        } else {
            throw new IllegalArgumentException("keySeq should be 5 or 6 in length");
        }
        this.h = (byte[])(seq.size() == 3 ? Arrays.clone(DEROctetString.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(2)), true).getOctets()) : null);
    }

    public static XMSSMTPrivateKey getInstance(Object o2) {
        if (o2 instanceof XMSSMTPrivateKey) {
            return (XMSSMTPrivateKey)o2;
        }
        if (o2 != null) {
            return new XMSSMTPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public int getVersion() {
        return this.a;
    }

    public long getIndex() {
        return this.b;
    }

    public long getMaxIndex() {
        return this.c;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone(this.d);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone(this.e);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.f);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.g);
    }

    public byte[] getBdsState() {
        return Arrays.clone(this.h);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.c >= 0L) {
            aSN1EncodableVector.add(new ASN1Integer(1L));
        } else {
            aSN1EncodableVector.add(new ASN1Integer(0L));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new ASN1Integer(this.b));
        aSN1EncodableVector2.add(new DEROctetString(this.d));
        aSN1EncodableVector2.add(new DEROctetString(this.e));
        aSN1EncodableVector2.add(new DEROctetString(this.f));
        aSN1EncodableVector2.add(new DEROctetString(this.g));
        if (this.c >= 0L) {
            aSN1EncodableVector2.add(new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(this.c)));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(this.h)));
        return new DERSequence(aSN1EncodableVector);
    }
}

