/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSPrivateKey
extends ASN1Object {
    private final int a;
    private final int b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;
    private final int g;
    private final byte[] h;

    public XMSSPrivateKey(int index, byte[] secretKeySeed, byte[] secretKeyPRF, byte[] publicSeed, byte[] root, byte[] bdsState) {
        this.a = 0;
        this.b = index;
        this.c = Arrays.clone(secretKeySeed);
        this.d = Arrays.clone(secretKeyPRF);
        this.e = Arrays.clone(publicSeed);
        this.f = Arrays.clone(root);
        this.h = Arrays.clone(bdsState);
        this.g = -1;
    }

    public XMSSPrivateKey(int index, byte[] secretKeySeed, byte[] secretKeyPRF, byte[] publicSeed, byte[] root, byte[] bdsState, int maxIndex) {
        this.a = 1;
        this.b = index;
        this.c = Arrays.clone(secretKeySeed);
        this.d = Arrays.clone(secretKeyPRF);
        this.e = Arrays.clone(publicSeed);
        this.f = Arrays.clone(root);
        this.h = Arrays.clone(bdsState);
        this.g = maxIndex;
    }

    private XMSSPrivateKey(ASN1Sequence seq) {
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(seq.getObjectAt(0));
        if (!aSN1Integer.hasValue(0) && !aSN1Integer.hasValue(1)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.a = aSN1Integer.intValueExact();
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(seq.getObjectAt(1));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact();
        this.c = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
        this.d = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets());
        this.e = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets());
        this.f = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets());
        if (aSN1Sequence.size() == 6) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(5));
            if (aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("unknown tag in XMSSPrivateKey");
            }
            this.g = ASN1Integer.getInstance(aSN1TaggedObject, false).intValueExact();
        } else if (aSN1Sequence.size() == 5) {
            this.g = -1;
        } else {
            throw new IllegalArgumentException("keySeq should be 5 or 6 in length");
        }
        this.h = (byte[])(seq.size() == 3 ? Arrays.clone(DEROctetString.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(2)), true).getOctets()) : null);
    }

    public static XMSSPrivateKey getInstance(Object o2) {
        if (o2 instanceof XMSSPrivateKey) {
            return (XMSSPrivateKey)o2;
        }
        if (o2 != null) {
            return new XMSSPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public int getVersion() {
        return this.a;
    }

    public int getIndex() {
        return this.b;
    }

    public int getMaxIndex() {
        return this.g;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone(this.c);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone(this.d);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.e);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.f);
    }

    public byte[] getBdsState() {
        return Arrays.clone(this.h);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.g >= 0) {
            aSN1EncodableVector.add(new ASN1Integer(1L));
        } else {
            aSN1EncodableVector.add(new ASN1Integer(0L));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new ASN1Integer(this.b));
        aSN1EncodableVector2.add(new DEROctetString(this.c));
        aSN1EncodableVector2.add(new DEROctetString(this.d));
        aSN1EncodableVector2.add(new DEROctetString(this.e));
        aSN1EncodableVector2.add(new DEROctetString(this.f));
        if (this.g >= 0) {
            aSN1EncodableVector2.add(new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(this.g)));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(this.h)));
        return new DERSequence(aSN1EncodableVector);
    }
}

