/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest a;
    private final MessageSigner b;
    private boolean c;

    public DigestingMessageSigner(MessageSigner messSigner, Digest messDigest) {
        this.b = messSigner;
        this.a = messDigest;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.c = forSigning;
        AsymmetricKeyParameter asymmetricKeyParameter = param instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)param).getParameters() : (AsymmetricKeyParameter)param;
        if (forSigning && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.b.init(forSigning, param);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        return this.b.generateSignature(byArray);
    }

    @Override
    public void update(byte b2) {
        this.a.update(b2);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.a.update(in, off, len);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for verification");
        }
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        return this.b.verifySignature(byArray, signature);
    }
}

