/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.falcon;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.i;
import java.security.SecureRandom;

public class FalconKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private FalconKeyGenerationParameters a;
    private SecureRandom b;
    private i c;
    private int d;
    private int e;
    private int f;
    private int g;

    @Override
    public void init(KeyGenerationParameters param) {
        this.a = (FalconKeyGenerationParameters)param;
        this.b = param.getRandom();
        this.d = ((FalconKeyGenerationParameters)param).getParameters().getLogN();
        this.e = ((FalconKeyGenerationParameters)param).getParameters().a();
        this.c = new i(this.d, this.e, this.b);
        int n2 = 1 << this.d;
        int n3 = 8;
        if (n2 == 1024) {
            n3 = 5;
        } else if (n2 == 256 || n2 == 512) {
            n3 = 6;
        } else if (n2 == 64 || n2 == 128) {
            n3 = 7;
        }
        this.f = 1 + 14 * n2 / 8;
        this.g = 1 + 2 * n3 * n2 / 8 + n2;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] byArray = new byte[this.f];
        byte[] byArray2 = new byte[this.g];
        byte[][] byArray3 = this.c.a(byArray, 0, byArray2, 0);
        FalconParameters falconParameters = this.a.getParameters();
        FalconPrivateKeyParameters falconPrivateKeyParameters = new FalconPrivateKeyParameters(falconParameters, byArray3[1], byArray3[2], byArray3[3], byArray3[0]);
        FalconPublicKeyParameters falconPublicKeyParameters = new FalconPublicKeyParameters(falconParameters, byArray3[0]);
        return new AsymmetricCipherKeyPair(falconPublicKeyParameters, falconPrivateKeyParameters);
    }
}

