/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.gemss;

abstract class Rem_GF2n {
    protected long mask;
    protected int ki;
    protected int ki64;

    Rem_GF2n() {
    }

    public abstract void rem_gf2n(long[] var1, int var2, long[] var3);

    public abstract void rem_gf2n_xor(long[] var1, int var2, long[] var3);

    public static class REM402_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;

        public REM402_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.a = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.b = k364;
            this.mask = mask;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long l3 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l4 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long l5 = Pol[12] >>> this.ki;
            long l6 = l2 >>> 39 ^ l3 << 25 ^ Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long l7 = l3 >>> 39 ^ l4 << 25 ^ Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long l8 = l4 >>> 39 ^ l5 << 25 ^ Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            P[p_cp] = Pol[0] ^ l6;
            P[p_cp + 1] = Pol[1] ^ l7;
            P[p_cp + 2] = Pol[2] ^ l8 ^ l6 << this.a;
            P[p_cp + 3] = Pol[3] ^ l2 ^ l6 >>> this.b ^ l7 << this.a;
            P[p_cp + 4] = Pol[4] ^ l3 ^ l7 >>> this.b ^ l8 << this.a;
            P[p_cp + 5] = Pol[5] ^ l4 ^ l8 >>> this.b ^ l2 << this.a;
            P[p_cp + 6] = (Pol[6] ^ l5 ^ l2 >>> this.b) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long l3 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l4 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long l5 = Pol[12] >>> this.ki;
            long l6 = l2 >>> 39 ^ l3 << 25 ^ Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long l7 = l3 >>> 39 ^ l4 << 25 ^ Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long l8 = l4 >>> 39 ^ l5 << 25 ^ Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            int n2 = p_cp;
            P[n2] = P[n2] ^ (Pol[0] ^ l6);
            int n3 = p_cp + 1;
            P[n3] = P[n3] ^ (Pol[1] ^ l7);
            int n4 = p_cp + 2;
            P[n4] = P[n4] ^ (Pol[2] ^ l8 ^ l6 << this.a);
            int n5 = p_cp + 3;
            P[n5] = P[n5] ^ (Pol[3] ^ l2 ^ l6 >>> this.b ^ l7 << this.a);
            int n6 = p_cp + 4;
            P[n6] = P[n6] ^ (Pol[4] ^ l3 ^ l7 >>> this.b ^ l8 << this.a);
            int n7 = p_cp + 5;
            P[n7] = P[n7] ^ (Pol[5] ^ l4 ^ l8 >>> this.b ^ l2 << this.a);
            int n8 = p_cp + 6;
            P[n8] = P[n8] ^ (Pol[6] ^ l5 ^ l2 >>> this.b) & this.mask;
        }
    }

    public static class REM384_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;

        public REM384_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.a = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.b = k364;
            this.mask = mask;
            this.c = ki - k3;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long l3 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long l4 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long l5 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long l6 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long l7 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l8 = l2 ^ l7 >>> this.c;
            P[p_cp] = Pol[0] ^ l8 ^ l8 << this.a;
            P[p_cp + 1] = Pol[1] ^ l3 ^ l2 >>> this.b ^ l3 << this.a;
            P[p_cp + 2] = Pol[2] ^ l4 ^ l3 >>> this.b ^ l4 << this.a;
            P[p_cp + 3] = Pol[3] ^ l5 ^ l4 >>> this.b ^ l5 << this.a;
            P[p_cp + 4] = Pol[4] ^ l6 ^ l5 >>> this.b ^ l6 << this.a;
            P[p_cp + 5] = (Pol[5] ^ l7 ^ l6 >>> this.b ^ l7 << this.a) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long l3 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long l4 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long l5 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long l6 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long l7 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l8 = l2 ^ l7 >>> this.c;
            int n2 = p_cp;
            P[n2] = P[n2] ^ (Pol[0] ^ l8 ^ l8 << this.a);
            int n3 = p_cp + 1;
            P[n3] = P[n3] ^ (Pol[1] ^ l3 ^ l2 >>> this.b ^ l3 << this.a);
            int n4 = p_cp + 2;
            P[n4] = P[n4] ^ (Pol[2] ^ l4 ^ l3 >>> this.b ^ l4 << this.a);
            int n5 = p_cp + 3;
            P[n5] = P[n5] ^ (Pol[3] ^ l5 ^ l4 >>> this.b ^ l5 << this.a);
            int n6 = p_cp + 4;
            P[n6] = P[n6] ^ (Pol[4] ^ l6 ^ l5 >>> this.b ^ l6 << this.a);
            int n7 = p_cp + 5;
            P[n7] = P[n7] ^ (Pol[5] ^ l7 ^ l6 >>> this.b ^ l7 << this.a) & this.mask;
        }
    }

    public static class REM384_SPECIALIZED358_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;
        private final int d;

        public REM384_SPECIALIZED358_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.a = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.b = k364;
            this.mask = mask;
            this.c = k364 + ki;
            this.d = k3 - ki;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long l3 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            P[p_cp + 2] = Pol[2] ^ l3 ^ l2 >>> this.b ^ l3 << this.a;
            long l4 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            P[p_cp + 3] = Pol[3] ^ l4 ^ l3 >>> this.b ^ l4 << this.a;
            l3 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            P[p_cp + 4] = Pol[4] ^ l3 ^ l4 >>> this.b ^ l3 << this.a;
            l4 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l5 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ l3 >>> this.c ^ l4 << this.d;
            P[p_cp + 5] = (Pol[5] ^ l4 ^ l3 >>> this.b) & this.mask;
            P[p_cp] = Pol[0] ^ l5 ^ l5 << this.a;
            P[p_cp + 1] = Pol[1] ^ l2 ^ l5 >>> this.b ^ l2 << this.a;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long l3 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            int n2 = p_cp + 2;
            P[n2] = P[n2] ^ (Pol[2] ^ l3 ^ l2 >>> this.b ^ l3 << this.a);
            long l4 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            int n3 = p_cp + 3;
            P[n3] = P[n3] ^ (Pol[3] ^ l4 ^ l3 >>> this.b ^ l4 << this.a);
            l3 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            int n4 = p_cp + 4;
            P[n4] = P[n4] ^ (Pol[4] ^ l3 ^ l4 >>> this.b ^ l3 << this.a);
            l4 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            int n5 = p_cp + 5;
            P[n5] = P[n5] ^ (Pol[5] ^ l4 ^ l3 >>> this.b) & this.mask;
            l3 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ l3 >>> this.c ^ l4 << this.d;
            int n6 = p_cp;
            P[n6] = P[n6] ^ (Pol[0] ^ l3 ^ l3 << this.a);
            int n7 = p_cp + 1;
            P[n7] = P[n7] ^ (Pol[1] ^ l2 ^ l3 >>> this.b ^ l2 << this.a);
        }
    }

    public static class REM384_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;
        private final int d;

        public REM384_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.a = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.b = k364;
            this.mask = mask;
            this.c = k364 + ki;
            this.d = k3 - ki;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long l3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long l4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long l5 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l6 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ l3 >>> this.c ^ l4 << this.d;
            long l7 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64 ^ l4 >>> this.c ^ l5 << this.d;
            P[p_cp] = Pol[0] ^ l6;
            P[p_cp + 1] = Pol[1] ^ l7 ^ l6 << this.a;
            P[p_cp + 2] = Pol[2] ^ l2 ^ l6 >>> this.b ^ l7 << this.a;
            P[p_cp + 3] = Pol[3] ^ l3 ^ l7 >>> this.b ^ l2 << this.a;
            P[p_cp + 4] = Pol[4] ^ l4 ^ l2 >>> this.b ^ l3 << this.a;
            P[p_cp + 5] = (Pol[5] ^ l5 ^ l3 >>> this.b) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long l3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long l4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long l5 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l6 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ l3 >>> this.c ^ l4 << this.d;
            long l7 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64 ^ l4 >>> this.c ^ l5 << this.d;
            int n2 = p_cp;
            P[n2] = P[n2] ^ (Pol[0] ^ l6);
            int n3 = p_cp + 1;
            P[n3] = P[n3] ^ (Pol[1] ^ l7 ^ l6 << this.a);
            int n4 = p_cp + 2;
            P[n4] = P[n4] ^ (Pol[2] ^ l2 ^ l6 >>> this.b ^ l7 << this.a);
            int n5 = p_cp + 3;
            P[n5] = P[n5] ^ (Pol[3] ^ l3 ^ l7 >>> this.b ^ l2 << this.a);
            int n6 = p_cp + 4;
            P[n6] = P[n6] ^ (Pol[4] ^ l4 ^ l2 >>> this.b ^ l3 << this.a);
            int n7 = p_cp + 5;
            P[n7] = P[n7] ^ (Pol[5] ^ l5 ^ l3 >>> this.b) & this.mask;
        }
    }

    public static class REM544_PENTANOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final int f;
        private final int g;
        private final int h;
        private final int i;

        public REM544_PENTANOMIAL_GF2X(int k1, int k2, int k3, int ki, int ki64, int k164, int k264, int k364, long mask) {
            this.a = k1;
            this.b = k2;
            this.c = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.d = k164;
            this.e = k264;
            this.f = k364;
            this.mask = mask;
            this.g = ki - k3;
            this.h = ki - k2;
            this.i = ki - k1;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[16] >>> this.ki;
            long l3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long l4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            P[p_cp + 1] = Pol[1] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c;
            P[p_cp] = Pol[0] ^ (l3 ^= l2 >>> this.g ^ l2 >>> this.h ^ l2 >>> this.i) ^ l3 << this.a ^ l3 << this.b ^ l3 << this.c;
            l3 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            P[p_cp + 2] = Pol[2] ^ l3 ^ l4 >>> this.d ^ l3 << this.a ^ l4 >>> this.e ^ l3 << this.b ^ l4 >>> this.f ^ l3 << this.c;
            l4 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            P[p_cp + 3] = Pol[3] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c;
            l3 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            P[p_cp + 4] = Pol[4] ^ l3 ^ l4 >>> this.d ^ l3 << this.a ^ l4 >>> this.e ^ l3 << this.b ^ l4 >>> this.f ^ l3 << this.c;
            l4 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            P[p_cp + 5] = Pol[5] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c;
            l3 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            P[p_cp + 6] = Pol[6] ^ l3 ^ l4 >>> this.d ^ l3 << this.a ^ l4 >>> this.e ^ l3 << this.b ^ l4 >>> this.f ^ l3 << this.c;
            l4 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            P[p_cp + 7] = Pol[7] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c;
            P[p_cp + 8] = (Pol[8] ^ l2 ^ l4 >>> this.d ^ l2 << this.a ^ l4 >>> this.e ^ l2 << this.b ^ l4 >>> this.f ^ l2 << this.c) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[16] >>> this.ki;
            long l3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long l4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            int n2 = p_cp + 1;
            P[n2] = P[n2] ^ (Pol[1] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c);
            int n3 = p_cp;
            P[n3] = P[n3] ^ (Pol[0] ^ (l3 ^= l2 >>> this.g ^ l2 >>> this.h ^ l2 >>> this.i) ^ l3 << this.a ^ l3 << this.b ^ l3 << this.c);
            l3 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            int n4 = p_cp + 2;
            P[n4] = P[n4] ^ (Pol[2] ^ l3 ^ l4 >>> this.d ^ l3 << this.a ^ l4 >>> this.e ^ l3 << this.b ^ l4 >>> this.f ^ l3 << this.c);
            l4 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            int n5 = p_cp + 3;
            P[n5] = P[n5] ^ (Pol[3] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c);
            l3 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            int n6 = p_cp + 4;
            P[n6] = P[n6] ^ (Pol[4] ^ l3 ^ l4 >>> this.d ^ l3 << this.a ^ l4 >>> this.e ^ l3 << this.b ^ l4 >>> this.f ^ l3 << this.c);
            l4 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            int n7 = p_cp + 5;
            P[n7] = P[n7] ^ (Pol[5] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c);
            l3 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            int n8 = p_cp + 6;
            P[n8] = P[n8] ^ (Pol[6] ^ l3 ^ l4 >>> this.d ^ l3 << this.a ^ l4 >>> this.e ^ l3 << this.b ^ l4 >>> this.f ^ l3 << this.c);
            l4 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            int n9 = p_cp + 7;
            P[n9] = P[n9] ^ (Pol[7] ^ l4 ^ l3 >>> this.d ^ l4 << this.a ^ l3 >>> this.e ^ l4 << this.b ^ l3 >>> this.f ^ l4 << this.c);
            int n10 = p_cp + 8;
            P[n10] = P[n10] ^ (Pol[8] ^ l2 ^ l4 >>> this.d ^ l2 << this.a ^ l4 >>> this.e ^ l2 << this.b ^ l4 >>> this.f ^ l2 << this.c) & this.mask;
        }
    }

    public static class REM544_PENTANOMIAL_K3_IS_128_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;
        private final int d;

        public REM544_PENTANOMIAL_K3_IS_128_GF2X(int k1, int k2, int ki, int ki64, int k164, int k264, long mask) {
            this.a = k1;
            this.b = k2;
            this.ki = ki;
            this.ki64 = ki64;
            this.c = k164;
            this.d = k264;
            this.mask = mask;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l3 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long l4 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            P[p_cp + 4] = Pol[4] ^ l4 ^ l2 ^ l3 >>> this.c ^ l4 << this.a ^ l3 >>> this.d ^ l4 << this.b;
            long l5 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            P[p_cp + 5] = Pol[5] ^ l5 ^ l3 ^ l4 >>> this.c ^ l5 << this.a ^ l4 >>> this.d ^ l5 << this.b;
            long l6 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            P[p_cp + 6] = Pol[6] ^ l6 ^ l4 ^ l5 >>> this.c ^ l6 << this.a ^ l5 >>> this.d ^ l6 << this.b;
            l4 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            P[p_cp + 7] = Pol[7] ^ l4 ^ l5 ^ l6 >>> this.c ^ l4 << this.a ^ l6 >>> this.d ^ l4 << this.b;
            l5 = Pol[16] >>> this.ki;
            P[p_cp + 8] = (Pol[8] ^ l5 ^ l6 ^ l4 >>> this.c ^ l5 << this.a ^ l4 >>> this.d ^ l5 << this.b) & this.mask;
            l6 = (Pol[8] ^ l6) >>> this.ki ^ (Pol[9] ^ l4) << this.ki64 ^ Pol[16] >>> this.d;
            l4 = (Pol[9] ^ l4) >>> this.ki ^ (Pol[10] ^ l5) << this.ki64;
            P[p_cp] = Pol[0] ^ l6 ^ l6 << this.a ^ l6 << this.b;
            P[p_cp + 1] = Pol[1] ^ l4 ^ l6 >>> this.c ^ l4 << this.a ^ l6 >>> this.d ^ l4 << this.b;
            P[p_cp + 2] = Pol[2] ^ l2 ^ l6 ^ l4 >>> this.c ^ l2 << this.a ^ l4 >>> this.d ^ l2 << this.b;
            P[p_cp + 3] = Pol[3] ^ l3 ^ l4 ^ l2 >>> this.c ^ l3 << this.a ^ l2 >>> this.d ^ l3 << this.b;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long l3 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long l4 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            int n2 = p_cp + 4;
            P[n2] = P[n2] ^ (Pol[4] ^ l4 ^ l2 ^ l3 >>> this.c ^ l4 << this.a ^ l3 >>> this.d ^ l4 << this.b);
            long l5 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            int n3 = p_cp + 5;
            P[n3] = P[n3] ^ (Pol[5] ^ l5 ^ l3 ^ l4 >>> this.c ^ l5 << this.a ^ l4 >>> this.d ^ l5 << this.b);
            long l6 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            int n4 = p_cp + 6;
            P[n4] = P[n4] ^ (Pol[6] ^ l6 ^ l4 ^ l5 >>> this.c ^ l6 << this.a ^ l5 >>> this.d ^ l6 << this.b);
            l4 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            int n5 = p_cp + 7;
            P[n5] = P[n5] ^ (Pol[7] ^ l4 ^ l5 ^ l6 >>> this.c ^ l4 << this.a ^ l6 >>> this.d ^ l4 << this.b);
            l5 = Pol[16] >>> this.ki;
            int n6 = p_cp + 8;
            P[n6] = P[n6] ^ (Pol[8] ^ l5 ^ l6 ^ l4 >>> this.c ^ l5 << this.a ^ l4 >>> this.d ^ l5 << this.b) & this.mask;
            l6 = (Pol[8] ^ l6) >>> this.ki ^ (Pol[9] ^ l4) << this.ki64 ^ Pol[16] >>> this.d;
            l4 = (Pol[9] ^ l4) >>> this.ki ^ (Pol[10] ^ l5) << this.ki64;
            int n7 = p_cp;
            P[n7] = P[n7] ^ (Pol[0] ^ l6 ^ l6 << this.a ^ l6 << this.b);
            int n8 = p_cp + 1;
            P[n8] = P[n8] ^ (Pol[1] ^ l4 ^ l6 >>> this.c ^ l4 << this.a ^ l6 >>> this.d ^ l4 << this.b);
            int n9 = p_cp + 2;
            P[n9] = P[n9] ^ (Pol[2] ^ l2 ^ l6 ^ l4 >>> this.c ^ l2 << this.a ^ l4 >>> this.d ^ l2 << this.b);
            int n10 = p_cp + 3;
            P[n10] = P[n10] ^ (Pol[3] ^ l3 ^ l4 ^ l2 >>> this.c ^ l3 << this.a ^ l2 >>> this.d ^ l3 << this.b);
        }
    }

    public static class REM288_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;
        private final int d;

        public REM288_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.a = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.b = k364;
            this.mask = mask;
            this.c = k364 + ki;
            this.d = k3 - ki;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long l3 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            P[p_cp + 2] = Pol[2] ^ l3 ^ l2 >>> this.b ^ l3 << this.a;
            long l4 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            P[p_cp + 3] = Pol[3] ^ l4 ^ l3 >>> this.b ^ l4 << this.a;
            long l5 = Pol[8] >>> this.ki;
            l3 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64 ^ l4 >>> this.c ^ l5 << this.d;
            P[p_cp + 4] = (Pol[4] ^ l5 ^ l4 >>> this.b ^ l5 << this.a) & this.mask;
            P[p_cp] = Pol[0] ^ l3 ^ l3 << this.a;
            P[p_cp + 1] = Pol[1] ^ l2 ^ l2 << this.a ^ l3 >>> this.b;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long l3 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            int n2 = p_cp + 2;
            P[n2] = P[n2] ^ (Pol[2] ^ l3 ^ l2 >>> this.b ^ l3 << this.a);
            long l4 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            int n3 = p_cp + 3;
            P[n3] = P[n3] ^ (Pol[3] ^ l4 ^ l3 >>> this.b ^ l4 << this.a);
            l3 = Pol[8] >>> this.ki;
            int n4 = p_cp + 4;
            P[n4] = P[n4] ^ (Pol[4] ^ l3 ^ l4 >>> this.b ^ l3 << this.a) & this.mask;
            l4 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64 ^ l4 >>> this.c ^ l3 << this.d;
            int n5 = p_cp;
            P[n5] = P[n5] ^ (Pol[0] ^ l4 ^ l4 << this.a);
            int n6 = p_cp + 1;
            P[n6] = P[n6] ^ (Pol[1] ^ l2 ^ l2 << this.a ^ l4 >>> this.b);
        }
    }

    public static class REM192_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int a;
        private final int b;
        private final int c;

        REM192_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.a = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.b = k364;
            this.mask = mask;
            this.c = ki - k3;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[2] >>> this.ki ^ Pol[3] << this.ki64;
            long l3 = Pol[3] >>> this.ki ^ Pol[4] << this.ki64;
            long l4 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64;
            P[p_cp + 1] = Pol[1] ^ l3 ^ l2 >>> this.b ^ l3 << this.a;
            P[p_cp + 2] = (Pol[2] ^ l4 ^ l3 >>> this.b ^ l4 << this.a) & this.mask;
            P[p_cp] = Pol[0] ^ (l2 ^= l4 >>> this.c) ^ l2 << this.a;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long l2 = Pol[2] >>> this.ki ^ Pol[3] << this.ki64;
            long l3 = Pol[3] >>> this.ki ^ Pol[4] << this.ki64;
            long l4 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64;
            int n2 = p_cp + 1;
            P[n2] = P[n2] ^ (Pol[1] ^ l3 ^ l2 >>> this.b ^ l3 << this.a);
            int n3 = p_cp + 2;
            P[n3] = P[n3] ^ (Pol[2] ^ l4 ^ l3 >>> this.b ^ l4 << this.a) & this.mask;
            int n4 = p_cp;
            P[n4] = P[n4] ^ (Pol[0] ^ (l2 ^= l4 >>> this.c) ^ l2 << this.a);
        }
    }
}

