/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.asn1.CMCEPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.CMCEPublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.FalconPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.FalconPublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.enterprisedt.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.Composer;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.util.a;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(privateKey, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey, ASN1Set attributes) throws IOException {
        if (privateKey instanceof QTESLAPrivateKeyParameters) {
            QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters = (QTESLAPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = a.a(qTESLAPrivateKeyParameters.getSecurityCategory());
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(qTESLAPrivateKeyParameters.getSecret()), attributes);
        }
        if (privateKey instanceof SPHINCSPrivateKeyParameters) {
            SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters = (SPHINCSPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(a.a(sPHINCSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(sPHINCSPrivateKeyParameters.getKeyData()));
        }
        if (privateKey instanceof NHPrivateKeyParameters) {
            NHPrivateKeyParameters nHPrivateKeyParameters = (NHPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = nHPrivateKeyParameters.getSecData();
            byte[] byArray = new byte[sArray.length * 2];
            for (int i2 = 0; i2 != sArray.length; ++i2) {
                Pack.shortToLittleEndian(sArray[i2], byArray, i2 * 2);
            }
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (privateKey instanceof LMSPrivateKeyParameters) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters = (LMSPrivateKeyParameters)privateKey;
            byte[] byArray = Composer.compose().u32str(1).bytes(lMSPrivateKeyParameters).build();
            byte[] byArray2 = Composer.compose().u32str(1).bytes(lMSPrivateKeyParameters.getPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes, byArray2);
        }
        if (privateKey instanceof HSSPrivateKeyParameters) {
            HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)privateKey;
            byte[] byArray = Composer.compose().u32str(hSSPrivateKeyParameters.getL()).bytes(hSSPrivateKeyParameters).build();
            byte[] byArray3 = Composer.compose().u32str(hSSPrivateKeyParameters.getL()).bytes(hSSPrivateKeyParameters.getPublicKey().getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes, byArray3);
        }
        if (privateKey instanceof SPHINCSPlusPrivateKeyParameters) {
            SPHINCSPlusPrivateKeyParameters sPHINCSPlusPrivateKeyParameters = (SPHINCSPlusPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(sPHINCSPlusPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(sPHINCSPlusPrivateKeyParameters.getEncoded()), attributes, sPHINCSPlusPrivateKeyParameters.getPublicKey());
        }
        if (privateKey instanceof PicnicPrivateKeyParameters) {
            PicnicPrivateKeyParameters picnicPrivateKeyParameters = (PicnicPrivateKeyParameters)privateKey;
            byte[] byArray = picnicPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(picnicPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        if (privateKey instanceof CMCEPrivateKeyParameters) {
            CMCEPrivateKeyParameters cMCEPrivateKeyParameters = (CMCEPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(cMCEPrivateKeyParameters.getParameters()));
            CMCEPublicKey cMCEPublicKey = new CMCEPublicKey(cMCEPrivateKeyParameters.reconstructPublicKey());
            CMCEPrivateKey cMCEPrivateKey = new CMCEPrivateKey(0, cMCEPrivateKeyParameters.getDelta(), cMCEPrivateKeyParameters.getC(), cMCEPrivateKeyParameters.getG(), cMCEPrivateKeyParameters.getAlpha(), cMCEPrivateKeyParameters.getS(), cMCEPublicKey);
            return new PrivateKeyInfo(algorithmIdentifier, cMCEPrivateKey, attributes);
        }
        if (privateKey instanceof XMSSPrivateKeyParameters) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(xMSSPrivateKeyParameters.getParameters().getHeight(), a.b(xMSSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.a(xMSSPrivateKeyParameters), attributes);
        }
        if (privateKey instanceof XMSSMTPrivateKeyParameters) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(xMSSMTPrivateKeyParameters.getParameters().getHeight(), xMSSMTPrivateKeyParameters.getParameters().getLayers(), a.b(xMSSMTPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.a(xMSSMTPrivateKeyParameters), attributes);
        }
        if (privateKey instanceof McElieceCCA2PrivateKeyParameters) {
            McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters = (McElieceCCA2PrivateKeyParameters)privateKey;
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = new McElieceCCA2PrivateKey(mcElieceCCA2PrivateKeyParameters.getN(), mcElieceCCA2PrivateKeyParameters.getK(), mcElieceCCA2PrivateKeyParameters.getField(), mcElieceCCA2PrivateKeyParameters.getGoppaPoly(), mcElieceCCA2PrivateKeyParameters.getP(), a.c(mcElieceCCA2PrivateKeyParameters.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            return new PrivateKeyInfo(algorithmIdentifier, mcElieceCCA2PrivateKey);
        }
        if (privateKey instanceof FrodoPrivateKeyParameters) {
            FrodoPrivateKeyParameters frodoPrivateKeyParameters = (FrodoPrivateKeyParameters)privateKey;
            byte[] byArray = frodoPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(frodoPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        if (privateKey instanceof SABERPrivateKeyParameters) {
            SABERPrivateKeyParameters sABERPrivateKeyParameters = (SABERPrivateKeyParameters)privateKey;
            byte[] byArray = sABERPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(sABERPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        if (privateKey instanceof NTRUPrivateKeyParameters) {
            NTRUPrivateKeyParameters nTRUPrivateKeyParameters = (NTRUPrivateKeyParameters)privateKey;
            byte[] byArray = nTRUPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(nTRUPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        if (privateKey instanceof FalconPrivateKeyParameters) {
            FalconPrivateKeyParameters falconPrivateKeyParameters = (FalconPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(falconPrivateKeyParameters.getParameters()));
            FalconPublicKey falconPublicKey = new FalconPublicKey(falconPrivateKeyParameters.getPublicKey());
            FalconPrivateKey falconPrivateKey = new FalconPrivateKey(0, falconPrivateKeyParameters.getSpolyf(), falconPrivateKeyParameters.getG(), falconPrivateKeyParameters.getSpolyF(), falconPublicKey);
            return new PrivateKeyInfo(algorithmIdentifier, falconPrivateKey, attributes);
        }
        if (privateKey instanceof KyberPrivateKeyParameters) {
            KyberPrivateKeyParameters kyberPrivateKeyParameters = (KyberPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(kyberPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(kyberPrivateKeyParameters.getEncoded()), attributes);
        }
        if (privateKey instanceof NTRULPRimePrivateKeyParameters) {
            NTRULPRimePrivateKeyParameters nTRULPRimePrivateKeyParameters = (NTRULPRimePrivateKeyParameters)privateKey;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getEnca()));
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getPk()));
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getRho()));
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getHash()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(nTRULPRimePrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DERSequence(aSN1EncodableVector), attributes);
        }
        if (privateKey instanceof SNTRUPrimePrivateKeyParameters) {
            SNTRUPrimePrivateKeyParameters sNTRUPrimePrivateKeyParameters = (SNTRUPrimePrivateKeyParameters)privateKey;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getF()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getGinv()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getPk()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getRho()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getHash()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(sNTRUPrimePrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, new DERSequence(aSN1EncodableVector), attributes);
        }
        if (privateKey instanceof DilithiumPrivateKeyParameters) {
            DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters = (DilithiumPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(dilithiumPrivateKeyParameters.getParameters()));
            DilithiumPublicKeyParameters dilithiumPublicKeyParameters = dilithiumPrivateKeyParameters.getPublicKeyParameters();
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(dilithiumPrivateKeyParameters.getEncoded()), attributes, dilithiumPublicKeyParameters.getEncoded());
        }
        if (privateKey instanceof BIKEPrivateKeyParameters) {
            BIKEPrivateKeyParameters bIKEPrivateKeyParameters = (BIKEPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(bIKEPrivateKeyParameters.getParameters()));
            byte[] byArray = bIKEPrivateKeyParameters.getEncoded();
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        if (privateKey instanceof HQCPrivateKeyParameters) {
            HQCPrivateKeyParameters hQCPrivateKeyParameters = (HQCPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(hQCPrivateKeyParameters.getParameters()));
            byte[] byArray = hQCPrivateKeyParameters.getEncoded();
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        if (privateKey instanceof RainbowPrivateKeyParameters) {
            RainbowPrivateKeyParameters rainbowPrivateKeyParameters = (RainbowPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(rainbowPrivateKeyParameters.getParameters()));
            byte[] byArray = rainbowPrivateKeyParameters.getEncoded();
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), attributes);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey a(XMSSPrivateKeyParameters xMSSPrivateKeyParameters) throws IOException {
        byte[] byArray = xMSSPrivateKeyParameters.getEncoded();
        int n2 = xMSSPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n3 = xMSSPrivateKeyParameters.getParameters().getHeight();
        int n4 = 4;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = 0;
        int n10 = (int)XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
        if (!XMSSUtil.isIndexValid(n3, n10)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
        BDS bDS = null;
        try {
            bDS = (BDS)XMSSUtil.deserialize(byArray6, BDS.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDS: " + classNotFoundException.getMessage());
        }
        if (bDS.getMaxIndex() != (1 << n3) - 1) {
            return new XMSSPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6, bDS.getMaxIndex());
        }
        return new XMSSPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    private static XMSSMTPrivateKey a(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) throws IOException {
        byte[] byArray = xMSSMTPrivateKeyParameters.getEncoded();
        int n2 = xMSSMTPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n3 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n4 = (n3 + 7) / 8;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = 0;
        int n10 = (int)XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
        if (!XMSSUtil.isIndexValid(n3, n10)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
        BDSStateMap bDSStateMap = null;
        try {
            bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray6, BDSStateMap.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDSStateMap: " + classNotFoundException.getMessage());
        }
        if (bDSStateMap.getMaxIndex() != (1L << n3) - 1L) {
            return new XMSSMTPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6, bDSStateMap.getMaxIndex());
        }
        return new XMSSMTPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6);
    }
}

