/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.asn1.CMCEPublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.KyberPublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.enterprisedt.bouncycastle.pqc.crypto.bike.BIKEParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.hqc.HQCParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.saber.SABERParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPublicKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PublicKeyFactory {
    private static Map a = new HashMap();

    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        if (keyInfoData == null) {
            throw new IllegalArgumentException("keyInfoData array null");
        }
        if (keyInfoData.length == 0) {
            throw new IllegalArgumentException("keyInfoData array empty");
        }
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo argument null");
        }
        return PublicKeyFactory.createKey(keyInfo, null);
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo argument null");
        }
        AlgorithmIdentifier algorithmIdentifier = keyInfo.getAlgorithm();
        t t2 = (t)a.get(algorithmIdentifier.getAlgorithm());
        if (t2 != null) {
            return t2.a(keyInfo, defaultParams);
        }
        throw new IOException("algorithm identifier in public key not recognised: " + algorithmIdentifier.getAlgorithm());
    }

    static {
        a.put(PQCObjectIdentifiers.qTESLA_p_I, new n());
        a.put(PQCObjectIdentifiers.qTESLA_p_III, new n());
        a.put(PQCObjectIdentifiers.sphincs256, new r());
        a.put(PQCObjectIdentifiers.newHope, new j());
        a.put(PQCObjectIdentifiers.xmss, new u());
        a.put(PQCObjectIdentifiers.xmss_mt, new v());
        a.put(IsaraObjectIdentifiers.id_alg_xmss, new u());
        a.put(IsaraObjectIdentifiers.id_alg_xmssmt, new v());
        a.put(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, new h());
        a.put(PQCObjectIdentifiers.mcElieceCca2, new i());
        a.put(BCObjectIdentifiers.sphincsPlus, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_128s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_128f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_192s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_192f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_256s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_256f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_128s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_128f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_192s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_192f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_256s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_256f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3_simple, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_128s, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_128f, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_128s, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_128f, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_192s, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_192f, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_192s, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_192f, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_256s, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_sha2_256f, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_256s, new s());
        a.put(BCObjectIdentifiers.sphincsPlus_shake_256f, new s());
        a.put(new ASN1ObjectIdentifier("1.3.9999.6.4.10"), new s());
        a.put(BCObjectIdentifiers.mceliece348864_r3, new b());
        a.put(BCObjectIdentifiers.mceliece348864f_r3, new b());
        a.put(BCObjectIdentifiers.mceliece460896_r3, new b());
        a.put(BCObjectIdentifiers.mceliece460896f_r3, new b());
        a.put(BCObjectIdentifiers.mceliece6688128_r3, new b());
        a.put(BCObjectIdentifiers.mceliece6688128f_r3, new b());
        a.put(BCObjectIdentifiers.mceliece6960119_r3, new b());
        a.put(BCObjectIdentifiers.mceliece6960119f_r3, new b());
        a.put(BCObjectIdentifiers.mceliece8192128_r3, new b());
        a.put(BCObjectIdentifiers.mceliece8192128f_r3, new b());
        a.put(BCObjectIdentifiers.frodokem640aes, new e());
        a.put(BCObjectIdentifiers.frodokem640shake, new e());
        a.put(BCObjectIdentifiers.frodokem976aes, new e());
        a.put(BCObjectIdentifiers.frodokem976shake, new e());
        a.put(BCObjectIdentifiers.frodokem1344aes, new e());
        a.put(BCObjectIdentifiers.frodokem1344shake, new e());
        a.put(BCObjectIdentifiers.lightsaberkem128r3, new p());
        a.put(BCObjectIdentifiers.saberkem128r3, new p());
        a.put(BCObjectIdentifiers.firesaberkem128r3, new p());
        a.put(BCObjectIdentifiers.lightsaberkem192r3, new p());
        a.put(BCObjectIdentifiers.saberkem192r3, new p());
        a.put(BCObjectIdentifiers.firesaberkem192r3, new p());
        a.put(BCObjectIdentifiers.lightsaberkem256r3, new p());
        a.put(BCObjectIdentifiers.saberkem256r3, new p());
        a.put(BCObjectIdentifiers.firesaberkem256r3, new p());
        a.put(BCObjectIdentifiers.ulightsaberkemr3, new p());
        a.put(BCObjectIdentifiers.usaberkemr3, new p());
        a.put(BCObjectIdentifiers.ufiresaberkemr3, new p());
        a.put(BCObjectIdentifiers.lightsaberkem90sr3, new p());
        a.put(BCObjectIdentifiers.saberkem90sr3, new p());
        a.put(BCObjectIdentifiers.firesaberkem90sr3, new p());
        a.put(BCObjectIdentifiers.ulightsaberkem90sr3, new p());
        a.put(BCObjectIdentifiers.usaberkem90sr3, new p());
        a.put(BCObjectIdentifiers.ufiresaberkem90sr3, new p());
        a.put(BCObjectIdentifiers.picnicl1fs, new m());
        a.put(BCObjectIdentifiers.picnicl1ur, new m());
        a.put(BCObjectIdentifiers.picnicl3fs, new m());
        a.put(BCObjectIdentifiers.picnicl3ur, new m());
        a.put(BCObjectIdentifiers.picnicl5fs, new m());
        a.put(BCObjectIdentifiers.picnicl5ur, new m());
        a.put(BCObjectIdentifiers.picnic3l1, new m());
        a.put(BCObjectIdentifiers.picnic3l3, new m());
        a.put(BCObjectIdentifiers.picnic3l5, new m());
        a.put(BCObjectIdentifiers.picnicl1full, new m());
        a.put(BCObjectIdentifiers.picnicl3full, new m());
        a.put(BCObjectIdentifiers.picnicl5full, new m());
        a.put(BCObjectIdentifiers.ntruhps2048509, new l());
        a.put(BCObjectIdentifiers.ntruhps2048677, new l());
        a.put(BCObjectIdentifiers.ntruhps4096821, new l());
        a.put(BCObjectIdentifiers.ntruhrss701, new l());
        a.put(BCObjectIdentifiers.falcon_512, new d());
        a.put(BCObjectIdentifiers.falcon_1024, new d());
        a.put(BCObjectIdentifiers.kyber512, new g());
        a.put(BCObjectIdentifiers.kyber768, new g());
        a.put(BCObjectIdentifiers.kyber1024, new g());
        a.put(BCObjectIdentifiers.kyber512_aes, new g());
        a.put(BCObjectIdentifiers.kyber768_aes, new g());
        a.put(BCObjectIdentifiers.kyber1024_aes, new g());
        a.put(BCObjectIdentifiers.ntrulpr653, new k());
        a.put(BCObjectIdentifiers.ntrulpr761, new k());
        a.put(BCObjectIdentifiers.ntrulpr857, new k());
        a.put(BCObjectIdentifiers.ntrulpr953, new k());
        a.put(BCObjectIdentifiers.ntrulpr1013, new k());
        a.put(BCObjectIdentifiers.ntrulpr1277, new k());
        a.put(BCObjectIdentifiers.sntrup653, new q());
        a.put(BCObjectIdentifiers.sntrup761, new q());
        a.put(BCObjectIdentifiers.sntrup857, new q());
        a.put(BCObjectIdentifiers.sntrup953, new q());
        a.put(BCObjectIdentifiers.sntrup1013, new q());
        a.put(BCObjectIdentifiers.sntrup1277, new q());
        a.put(BCObjectIdentifiers.dilithium2, new c());
        a.put(BCObjectIdentifiers.dilithium3, new c());
        a.put(BCObjectIdentifiers.dilithium5, new c());
        a.put(BCObjectIdentifiers.dilithium2_aes, new c());
        a.put(BCObjectIdentifiers.dilithium3_aes, new c());
        a.put(BCObjectIdentifiers.dilithium5_aes, new c());
        a.put(BCObjectIdentifiers.bike128, new a());
        a.put(BCObjectIdentifiers.bike192, new a());
        a.put(BCObjectIdentifiers.bike256, new a());
        a.put(BCObjectIdentifiers.hqc128, new f());
        a.put(BCObjectIdentifiers.hqc192, new f());
        a.put(BCObjectIdentifiers.hqc256, new f());
        a.put(BCObjectIdentifiers.rainbow_III_classic, new o());
        a.put(BCObjectIdentifiers.rainbow_III_circumzenithal, new o());
        a.put(BCObjectIdentifiers.rainbow_III_compressed, new o());
        a.put(BCObjectIdentifiers.rainbow_V_classic, new o());
        a.put(BCObjectIdentifiers.rainbow_V_circumzenithal, new o());
        a.put(BCObjectIdentifiers.rainbow_V_compressed, new o());
    }

    private static class o
    extends t {
        private o() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            RainbowParameters rainbowParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.p(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new RainbowPublicKeyParameters(rainbowParameters, byArray);
        }
    }

    private static class f
    extends t {
        private f() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            try {
                byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
                HQCParameters hQCParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.o(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new HQCPublicKeyParameters(hQCParameters, byArray);
            }
            catch (Exception exception) {
                byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getOctets();
                HQCParameters hQCParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.o(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new HQCPublicKeyParameters(hQCParameters, byArray);
            }
        }
    }

    private static class a
    extends t {
        private a() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            try {
                byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
                BIKEParameters bIKEParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.n(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new BIKEPublicKeyParameters(bIKEParameters, byArray);
            }
            catch (Exception exception) {
                byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getOctets();
                BIKEParameters bIKEParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.n(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new BIKEPublicKeyParameters(bIKEParameters, byArray);
            }
        }
    }

    static class c
    extends t {
        c() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            DilithiumParameters dilithiumParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.m(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return c.a(dilithiumParameters, subjectPublicKeyInfo.getPublicKeyData());
        }

        static DilithiumPublicKeyParameters a(DilithiumParameters dilithiumParameters, ASN1BitString aSN1BitString) {
            try {
                ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(aSN1BitString.getOctets());
                if (aSN1Primitive instanceof ASN1Sequence) {
                    ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Primitive);
                    return new DilithiumPublicKeyParameters(dilithiumParameters, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
                }
                byte[] byArray = ASN1OctetString.getInstance(aSN1Primitive).getOctets();
                return new DilithiumPublicKeyParameters(dilithiumParameters, byArray);
            }
            catch (Exception exception) {
                return new DilithiumPublicKeyParameters(dilithiumParameters, aSN1BitString.getOctets());
            }
        }
    }

    private static class q
    extends t {
        private q() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            SNTRUPrimeParameters sNTRUPrimeParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.l(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new SNTRUPrimePublicKeyParameters(sNTRUPrimeParameters, byArray);
        }
    }

    private static class k
    extends t {
        private k() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            NTRULPRimeParameters nTRULPRimeParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.k(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new NTRULPRimePublicKeyParameters(nTRULPRimeParameters, byArray);
        }
    }

    private static class g
    extends t {
        private g() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            KyberParameters kyberParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.j(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            try {
                ASN1Primitive aSN1Primitive = subjectPublicKeyInfo.parsePublicKey();
                KyberPublicKey kyberPublicKey = KyberPublicKey.getInstance(aSN1Primitive);
                return new KyberPublicKeyParameters(kyberParameters, kyberPublicKey.getT(), kyberPublicKey.getRho());
            }
            catch (Exception exception) {
                return new KyberPublicKeyParameters(kyberParameters, subjectPublicKeyInfo.getPublicKeyData().getOctets());
            }
        }
    }

    private static class d
    extends t {
        private d() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getOctets();
            FalconParameters falconParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.h(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new FalconPublicKeyParameters(falconParameters, Arrays.copyOfRange(byArray, 1, byArray.length));
        }
    }

    private static class l
    extends t {
        private l() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            NTRUParameters nTRUParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.i(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new NTRUPublicKeyParameters(nTRUParameters, byArray);
        }
    }

    private static class m
    extends t {
        private m() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            PicnicParameters picnicParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.g(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new PicnicPublicKeyParameters(picnicParameters, byArray);
        }
    }

    private static class e
    extends t {
        private e() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            FrodoParameters frodoParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.e(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new FrodoPublicKeyParameters(frodoParameters, byArray);
        }
    }

    private static class i
    extends t {
        private i() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            McElieceCCA2PublicKey mcElieceCCA2PublicKey = McElieceCCA2PublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
            return new McElieceCCA2PublicKeyParameters(mcElieceCCA2PublicKey.getN(), mcElieceCCA2PublicKey.getT(), mcElieceCCA2PublicKey.getG(), com.enterprisedt.bouncycastle.pqc.crypto.util.a.b(mcElieceCCA2PublicKey.getDigest().getAlgorithm()));
        }
    }

    private static class p
    extends t {
        private p() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(ASN1Sequence.getInstance(subjectPublicKeyInfo.parsePublicKey()).getObjectAt(0)).getOctets();
            SABERParameters sABERParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.f(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            return new SABERPublicKeyParameters(sABERParameters, byArray);
        }
    }

    private static class b
    extends t {
        private b() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            try {
                byte[] byArray = CMCEPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey()).getT();
                CMCEParameters cMCEParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.d(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new CMCEPublicKeyParameters(cMCEParameters, byArray);
            }
            catch (Exception exception) {
                byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getOctets();
                CMCEParameters cMCEParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.d(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new CMCEPublicKeyParameters(cMCEParameters, byArray);
            }
        }
    }

    private static class s
    extends t {
        private s() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            try {
                byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
                SPHINCSPlusParameters sPHINCSPlusParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.c(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new SPHINCSPlusPublicKeyParameters(sPHINCSPlusParameters, Arrays.copyOfRange(byArray, 4, byArray.length));
            }
            catch (Exception exception) {
                byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getOctets();
                SPHINCSPlusParameters sPHINCSPlusParameters = com.enterprisedt.bouncycastle.pqc.crypto.util.a.c(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
                return new SPHINCSPlusPublicKeyParameters(sPHINCSPlusParameters, byArray);
            }
        }
    }

    private static class h
    extends t {
        private h() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            if (Pack.bigEndianToInt(byArray, 0) == 1) {
                return LMSPublicKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length));
            }
            if (byArray.length == 64) {
                byArray = Arrays.copyOfRange(byArray, 4, byArray.length);
            }
            return HSSPublicKeyParameters.getInstance(byArray);
        }
    }

    private static class v
    extends t {
        private v() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (xMSSMTKeyParams != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
                XMSSPublicKey xMSSPublicKey = XMSSPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
                return new XMSSMTPublicKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), com.enterprisedt.bouncycastle.pqc.crypto.util.a.a(aSN1ObjectIdentifier))).withPublicSeed(xMSSPublicKey.getPublicSeed()).withRoot(xMSSPublicKey.getRoot()).build();
            }
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            return new XMSSMTPublicKeyParameters.Builder(XMSSMTParameters.lookupByOID(Pack.bigEndianToInt(byArray, 0))).withPublicKey(byArray).build();
        }
    }

    private static class u
    extends t {
        private u() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (xMSSKeyParams != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = xMSSKeyParams.getTreeDigest().getAlgorithm();
                XMSSPublicKey xMSSPublicKey = XMSSPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
                return new XMSSPublicKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), com.enterprisedt.bouncycastle.pqc.crypto.util.a.a(aSN1ObjectIdentifier))).withPublicSeed(xMSSPublicKey.getPublicSeed()).withRoot(xMSSPublicKey.getRoot()).build();
            }
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            return new XMSSPublicKeyParameters.Builder(XMSSParameters.lookupByOID(Pack.bigEndianToInt(byArray, 0))).withPublicKey(byArray).build();
        }
    }

    private static class j
    extends t {
        private j() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            return new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        }
    }

    private static class r
    extends t {
        private r() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            return new SPHINCSPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes(), com.enterprisedt.bouncycastle.pqc.crypto.util.a.a(SPHINCS256KeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters())));
        }
    }

    private static class n
    extends t {
        private n() {
        }

        @Override
        AsymmetricKeyParameter a(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) throws IOException {
            return new QTESLAPublicKeyParameters(com.enterprisedt.bouncycastle.pqc.crypto.util.a.a(subjectPublicKeyInfo.getAlgorithm()), subjectPublicKeyInfo.getPublicKeyData().getOctets());
        }
    }

    private static abstract class t {
        private t() {
        }

        abstract AsymmetricKeyParameter a(SubjectPublicKeyInfo var1, Object var2) throws IOException;
    }
}

