/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class BDSStateMap
implements Serializable {
    private static final long serialVersionUID = -3464451825208522308L;
    private final Map<Integer, BDS> a = new TreeMap<Integer, BDS>();
    private transient long b;

    BDSStateMap(long maxIndex) {
        this.b = maxIndex;
    }

    BDSStateMap(BDSStateMap stateMap, long maxIndex) {
        for (Integer n2 : stateMap.a.keySet()) {
            this.a.put(n2, new BDS(stateMap.a.get(n2)));
        }
        this.b = maxIndex;
    }

    BDSStateMap(XMSSMTParameters params, long globalIndex, byte[] publicSeed, byte[] secretKeySeed) {
        this.b = (1L << params.getHeight()) - 1L;
        for (long i2 = 0L; i2 < globalIndex; ++i2) {
            this.a(params, i2, publicSeed, secretKeySeed);
        }
    }

    public long getMaxIndex() {
        return this.b;
    }

    void a(XMSSMTParameters xMSSMTParameters, long l2, byte[] byArray, byte[] byArray2) {
        XMSSParameters xMSSParameters = xMSSMTParameters.getXMSSParameters();
        int n2 = xMSSParameters.getHeight();
        long l3 = XMSSUtil.getTreeIndex(l2, n2);
        int n3 = XMSSUtil.getLeafIndex(l2, n2);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n3).build();
        if (n3 < (1 << n2) - 1) {
            if (this.a(0) == null || n3 == 0) {
                this.a(0, new BDS(xMSSParameters, byArray, byArray2, oTSHashAddress));
            }
            this.a(0, byArray, byArray2, oTSHashAddress);
        }
        for (int i2 = 1; i2 < xMSSMTParameters.getLayers(); ++i2) {
            n3 = XMSSUtil.getLeafIndex(l3, n2);
            l3 = XMSSUtil.getTreeIndex(l3, n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n3).build();
            if (this.a.get(i2) == null || XMSSUtil.isNewBDSInitNeeded(l2, n2, i2)) {
                this.a.put(i2, new BDS(xMSSParameters, byArray, byArray2, oTSHashAddress));
            }
            if (n3 >= (1 << n2) - 1 || !XMSSUtil.isNewAuthenticationPathNeeded(l2, n2, i2)) continue;
            this.a(i2, byArray, byArray2, oTSHashAddress);
        }
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    BDS a(int n2) {
        return this.a.get(Integers.valueOf(n2));
    }

    BDS a(int n2, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        return this.a.put(Integers.valueOf(n2), this.a.get(Integers.valueOf(n2)).getNextState(byArray, byArray2, oTSHashAddress));
    }

    void a(int n2, BDS bDS) {
        this.a.put(Integers.valueOf(n2), bDS);
    }

    public BDSStateMap withWOTSDigest(ASN1ObjectIdentifier digestName) {
        BDSStateMap bDSStateMap = new BDSStateMap(this.b);
        for (Integer n2 : this.a.keySet()) {
            bDSStateMap.a.put(n2, this.a.get(n2).withWOTSDigest(digestName));
        }
        return bDSStateMap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.b = in.available() != 0 ? in.readLong() : 0L;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeLong(this.b);
    }
}

